/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.cinder.v1.domain.Volume;
import org.jclouds.openstack.cinder.v1.options.CreateVolumeOptions;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptyFluentIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface VolumeAsyncApi {
    @GET
    @Path(value="/volumes")
    @SelectJson(value={"volumes"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Volume>> list();

    @GET
    @Path(value="/volumes/detail")
    @SelectJson(value={"volumes"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Volume>> listInDetail();

    @GET
    @Path(value="/volumes/{id}")
    @SelectJson(value={"volume"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Volume> get(@PathParam(value="id") String var1);

    @POST
    @Path(value="/volumes")
    @SelectJson(value={"volume"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=CreateVolumeOptions.class)
    public ListenableFuture<? extends Volume> create(@PayloadParam(value="size") int var1, CreateVolumeOptions ... var2);

    @DELETE
    @Path(value="/volumes/{id}")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);
}

