/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.cinder.v1.domain.VolumeAttachment;

public class Volume {
    private final String id;
    private final Status status;
    private final int size;
    @Named(value="availability_zone")
    private final String zone;
    @Named(value="created_at")
    private final Date created;
    private final Set<VolumeAttachment> attachments;
    @Named(value="volume_type")
    private final String volumeType;
    @Named(value="snapshot_id")
    private final String snapshotId;
    @Named(value="display_name")
    private final String name;
    @Named(value="display_description")
    private final String description;
    private final Map<String, String> metadata;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolume(this);
    }

    public static Volume forId(String volumeId) {
        return ((Builder)((Builder)((Builder)((Builder)Volume.builder().id(volumeId)).status(Status.UNRECOGNIZED)).zone("nova")).created(new Date())).build();
    }

    @ConstructorProperties(value={"id", "status", "size", "availability_zone", "created_at", "attachments", "volume_type", "snapshot_id", "display_name", "display_description", "metadata"})
    protected Volume(String id, Status status, int size, String zone, Date created, @Nullable Set<VolumeAttachment> attachments, @Nullable String volumeType, @Nullable String snapshotId, @Nullable String name, @Nullable String description, @Nullable Map<String, String> metadata) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.status = Preconditions.checkNotNull(status, "status");
        this.size = size;
        this.zone = Preconditions.checkNotNull(zone, "zone");
        this.created = Preconditions.checkNotNull(created, "created");
        this.attachments = attachments == null ? ImmutableSet.of() : ImmutableSet.copyOf(attachments);
        this.volumeType = volumeType;
        this.snapshotId = snapshotId;
        this.name = name;
        this.description = description;
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getSize() {
        return this.size;
    }

    public String getZone() {
        return this.zone;
    }

    public Date getCreated() {
        return this.created;
    }

    public Set<VolumeAttachment> getAttachments() {
        return this.attachments;
    }

    @Nullable
    public String getVolumeType() {
        return this.volumeType;
    }

    @Nullable
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.status, this.size, this.zone, this.created, this.attachments, this.volumeType, this.snapshotId, this.name, this.description, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Volume that = (Volume)Volume.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.size, that.size) && Objects.equal(this.zone, that.zone) && Objects.equal(this.created, that.created) && Objects.equal(this.attachments, that.attachments) && Objects.equal(this.volumeType, that.volumeType) && Objects.equal(this.snapshotId, that.snapshotId) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.metadata, that.metadata);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("status", (Object)this.status).add("size", this.size).add("zone", this.zone).add("created", this.created).add("attachments", this.attachments).add("volumeType", this.volumeType).add("snapshotId", this.snapshotId).add("name", this.name).add("description", this.description).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected Status status;
        protected int size;
        protected String zone;
        protected Date created;
        protected Set<VolumeAttachment> attachments = ImmutableSet.of();
        protected String volumeType;
        protected String snapshotId;
        protected String name;
        protected String description;
        protected Map<String, String> metadata = ImmutableMap.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T status(Status status) {
            this.status = status;
            return this.self();
        }

        public T size(int size) {
            this.size = size;
            return this.self();
        }

        public T zone(String zone) {
            this.zone = zone;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T attachments(Set<VolumeAttachment> attachments) {
            this.attachments = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(attachments, "attachments"));
            return this.self();
        }

        public T attachments(VolumeAttachment ... in) {
            return this.attachments(ImmutableSet.copyOf(in));
        }

        public T volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this.self();
        }

        public T snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
            return this.self();
        }

        public Volume build() {
            return new Volume(this.id, this.status, this.size, this.zone, this.created, this.attachments, this.volumeType, this.snapshotId, this.name, this.description, this.metadata);
        }

        public T fromVolume(Volume in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).status(in.getStatus())).size(in.getSize())).zone(in.getZone())).created(in.getCreated())).attachments(in.getAttachments())).volumeType(in.getVolumeType())).snapshotId(in.getSnapshotId())).name(in.getName())).description(in.getDescription())).metadata(in.getMetadata());
        }
    }

    public static enum Status {
        CREATING,
        AVAILABLE,
        ATTACHING,
        IN_USE,
        DELETING,
        ERROR,
        ERROR_DELETING,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(status, "status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

