/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.CinderAsyncApi;
import org.jclouds.openstack.cinder.v1.config.CinderParserModule;
import org.jclouds.openstack.cinder.v1.config.CinderRestClientModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class CinderApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 4525672099385581765L;
    public static final TypeToken<RestContext<CinderApi, CinderAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<CinderApi, CinderAsyncApi>>(){
        private static final long serialVersionUID = -2850937833892503251L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public CinderApiMetadata() {
        this(new Builder());
    }

    protected CinderApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "volume");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(CinderApi.class, CinderAsyncApi.class);
            this.id("openstack-cinder").name("OpenStack Cinder Folsom API").identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant").credentialName("${password}").endpointName("Keystone base URL ending in /v2.0/").documentation(URI.create("http://api.openstack.org/")).version("1").defaultEndpoint("http://localhost:5000/v2.0/").defaultProperties(CinderApiMetadata.defaultProperties()).defaultModules((Set)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(KeystoneAuthenticationModule.class)).add(KeystoneAuthenticationModule.ZoneModule.class)).add(CinderParserModule.class)).add(CinderRestClientModule.class)).build()));
        }

        @Override
        public CinderApiMetadata build() {
            return new CinderApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

