/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.jclouds.logging.config.LoggingModule;
import org.jclouds.logging.jdk.config.JDKLoggingModule;

public class LoggingModules {
    private static Iterable<LoggingModule> fromServiceLoader() {
        return ServiceLoader.load(LoggingModule.class);
    }

    public static Iterable<LoggingModule> all() {
        return LoggingModules.fromServiceLoader();
    }

    public static LoggingModule firstOrJDKLoggingModule() {
        try {
            return (LoggingModule)Iterables.find(ServiceLoader.load(LoggingModule.class), Predicates.not(Predicates.instanceOf(JDKLoggingModule.class)));
        }
        catch (NoSuchElementException e) {
            return new JDKLoggingModule();
        }
    }
}

