/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.lifecycle.config;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ExecutionList;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.jclouds.concurrent.MoreExecutors;
import org.jclouds.lifecycle.Closer;

public class LifeCycleModule
extends AbstractModule {
    @Override
    protected void configure() {
        Closeable executorCloser = new Closeable(){
            @Inject
            @Named(value="jclouds.user-threads")
            ExecutorService userExecutor;
            @Inject
            @Named(value="jclouds.io-worker-threads")
            ExecutorService ioExecutor;
            @Inject(optional=true)
            @Named(value="jclouds.scheduler-threads")
            ScheduledExecutorService scheduledExecutor;

            @Override
            public void close() throws IOException {
                assert (this.userExecutor != null);
                this.userExecutor.shutdownNow();
                assert (this.ioExecutor != null);
                this.ioExecutor.shutdownNow();
                if (this.scheduledExecutor != null) {
                    this.scheduledExecutor.shutdownNow();
                }
            }
        };
        this.binder().requestInjection(executorCloser);
        Closer closer = new Closer();
        closer.addToClose(executorCloser);
        this.bind(Closer.class).toInstance(closer);
        ExecutionList list = new ExecutionList();
        this.bindPostInjectionInvoke(closer, list);
        this.bind(ExecutionList.class).toInstance(list);
    }

    protected void bindPostInjectionInvoke(final Closer closer, final ExecutionList list) {
        this.bindListener(Matchers.any(), new TypeListener(){

            @Override
            public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
                HashSet<Method> methods = new HashSet<Method>();
                for (Class<I> type = injectableType.getRawType(); type != null; type = type.getSuperclass()) {
                    methods.addAll(Arrays.asList(type.getDeclaredMethods()));
                }
                for (Method method : methods) {
                    this.invokePostConstructMethodAfterInjection(encounter, method);
                    this.associatePreDestroyWithCloser(closer, encounter, method);
                }
            }

            private <I> void associatePreDestroyWithCloser(final Closer closer2, TypeEncounter<I> encounter, final Method method) {
                PreDestroy preDestroy = method.getAnnotation(PreDestroy.class);
                if (preDestroy != null) {
                    encounter.register(new InjectionListener<I>(){

                        @Override
                        public void afterInjection(final I injectee) {
                            closer2.addToClose(new Closeable(){

                                @Override
                                public void close() throws IOException {
                                    try {
                                        method.invoke(injectee, new Object[0]);
                                    }
                                    catch (InvocationTargetException ie) {
                                        Throwable e = ie.getTargetException();
                                        throw new IOException(e.getMessage());
                                    }
                                    catch (IllegalAccessException e) {
                                        throw new IOException(e.getMessage());
                                    }
                                }
                            });
                        }
                    });
                }
            }

            private <I> void invokePostConstructMethodAfterInjection(TypeEncounter<I> encounter, final Method method) {
                PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
                if (postConstruct != null) {
                    encounter.register(new InjectionListener<I>(){

                        @Override
                        public void afterInjection(final I injectee) {
                            list.add(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        method.invoke(injectee, new Object[0]);
                                    }
                                    catch (InvocationTargetException ie) {
                                        Throwable e = ie.getTargetException();
                                        throw Throwables.propagate(e);
                                    }
                                    catch (IllegalAccessException e) {
                                        throw Throwables.propagate(e);
                                    }
                                }
                            }, MoreExecutors.sameThreadExecutor());
                        }
                    });
                }
            }
        });
    }
}

