/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;

public class NamingStrategies {

    public static class AnnotationConstructorNamingStrategy
    extends AnnotationBasedNamingStrategy
    implements ConstructorFieldNamingStrategy {
        private final Set<Class<? extends Annotation>> markers;

        public AnnotationConstructorNamingStrategy(Iterable<? extends Class<? extends Annotation>> markers, Iterable<? extends NameExtractor> extractors) {
            super(extractors);
            this.markers = ImmutableSet.copyOf(Preconditions.checkNotNull(markers, "you must supply at least one annotation to mark deserialization constructors"));
        }

        @Override
        public <T> Constructor<? super T> getDeserializationConstructor(Class<?> raw) {
            for (Constructor<?> ctor : raw.getDeclaredConstructors()) {
                for (Class<? extends Annotation> deserializationCtorAnnotation : this.markers) {
                    if (!ctor.isAnnotationPresent(deserializationCtorAnnotation)) continue;
                    return ctor;
                }
            }
            return null;
        }

        @Override
        public String translateName(Constructor<?> c, int index) {
            String[] names;
            String name = null;
            if (this.markers.contains(ConstructorProperties.class) && c.getAnnotation(ConstructorProperties.class) != null && (names = c.getAnnotation(ConstructorProperties.class).value()) != null && names.length > index) {
                name = names[index];
            }
            for (Annotation annotation : c.getParameterAnnotations()[index]) {
                if (!this.annotationToNameExtractor.containsKey(annotation.annotationType())) continue;
                name = ((NameExtractor)this.annotationToNameExtractor.get(annotation.annotationType())).extractName(annotation);
                break;
            }
            return name;
        }
    }

    public static interface ConstructorFieldNamingStrategy {
        public String translateName(Constructor<?> var1, int var2);

        public <T> Constructor<? super T> getDeserializationConstructor(Class<?> var1);
    }

    public static class AnnotationOrNameFieldNamingStrategy
    extends AnnotationFieldNamingStrategy
    implements FieldNamingStrategy {
        public AnnotationOrNameFieldNamingStrategy(NameExtractor ... extractors) {
            this(ImmutableSet.copyOf(extractors));
        }

        public AnnotationOrNameFieldNamingStrategy(Iterable<? extends NameExtractor> extractors) {
            super(extractors);
        }

        @Override
        public String translateName(Field f) {
            String result = super.translateName(f);
            return result == null ? f.getName() : result;
        }
    }

    public static class AnnotationFieldNamingStrategy
    extends AnnotationBasedNamingStrategy
    implements FieldNamingStrategy {
        public AnnotationFieldNamingStrategy(Iterable<? extends NameExtractor> extractors) {
            super(extractors);
            Preconditions.checkArgument(extractors.iterator().hasNext(), "you must supply at least one name extractor, for example: " + ExtractSerializedName.class.getSimpleName());
        }

        @Override
        public String translateName(Field f) {
            for (Annotation annotation : f.getAnnotations()) {
                if (!this.annotationToNameExtractor.containsKey(annotation.annotationType())) continue;
                return ((NameExtractor)this.annotationToNameExtractor.get(annotation.annotationType())).extractName(annotation);
            }
            return null;
        }
    }

    public static abstract class AnnotationBasedNamingStrategy {
        protected final Map<Class<? extends Annotation>, ? extends NameExtractor> annotationToNameExtractor;
        private String forToString;

        public AnnotationBasedNamingStrategy(Iterable<? extends NameExtractor> extractors) {
            Preconditions.checkNotNull(extractors, "means to extract names by annotations");
            this.annotationToNameExtractor = Maps.uniqueIndex(extractors, new Function<NameExtractor, Class<? extends Annotation>>(){

                @Override
                public Class<? extends Annotation> apply(NameExtractor input) {
                    return input.annotationType();
                }
            });
            this.forToString = Joiner.on(",").join(Iterables.transform(extractors, new Function<NameExtractor, String>(){

                @Override
                public String apply(NameExtractor input) {
                    return input.annotationType().getName();
                }
            }));
        }

        public String toString() {
            return "AnnotationBasedNamingStrategy requiring one of " + this.forToString;
        }
    }

    public static class ExtractNamed
    extends NameExtractor<Named> {
        public ExtractNamed() {
            super(Named.class);
        }

        @Override
        public String extractName(Named in) {
            return Preconditions.checkNotNull(in, "input annotation").value();
        }
    }

    public static class ExtractSerializedName
    extends NameExtractor<SerializedName> {
        public ExtractSerializedName() {
            super(SerializedName.class);
        }

        @Override
        public String extractName(SerializedName in) {
            return Preconditions.checkNotNull(in, "input annotation").value();
        }
    }

    public static abstract class NameExtractor<A extends Annotation> {
        protected final Class<A> annotationType;

        protected NameExtractor(Class<A> annotationType) {
            this.annotationType = Preconditions.checkNotNull(annotationType, "annotationType");
        }

        public abstract String extractName(A var1);

        public Class<A> annotationType() {
            return this.annotationType;
        }

        public String toString() {
            return "nameExtractor(" + this.annotationType.getSimpleName() + ")";
        }

        public int hashCode() {
            return this.annotationType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.annotationType.equals(((NameExtractor)NameExtractor.class.cast((Object)obj)).annotationType);
        }
    }
}

