/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import javax.annotation.Resource;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.InvocationContext;

public class ParseContentMD5FromHeaders
implements Function<HttpResponse, byte[]>,
InvocationContext<ParseContentMD5FromHeaders> {
    @Resource
    protected Logger logger = Logger.NULL;
    private HttpRequest request;

    @Override
    public byte[] apply(HttpResponse from) {
        HttpUtils.releasePayload(from);
        if (from.getPayload() != null) {
            return from.getPayload().getContentMetadata().getContentMD5();
        }
        throw new NoContentMD5Exception(this.request, from);
    }

    @Override
    public ParseContentMD5FromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }

    public static class NoContentMD5Exception
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final HttpRequest request;
        private final HttpResponse response;

        public NoContentMD5Exception(HttpRequest request, HttpResponse response) {
            super(String.format("no MD5 returned from request: %s; response %s", request, response));
            this.request = request;
            this.response = response;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }
    }
}

