/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;

public enum MediaType {
    DISK,
    CDROM,
    UNRECOGNIZED;


    public String value() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.value();
    }

    public static MediaType fromValue(String type) {
        try {
            return MediaType.valueOf(Preconditions.checkNotNull(type, "type").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

