/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.suppliers;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionClient;
import org.jclouds.location.Region;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.util.Suppliers2;

@Singleton
public class DescribeRegionsForRegionURIs
implements RegionIdToURISupplier {
    private final AvailabilityZoneAndRegionClient client;

    @Inject
    public DescribeRegionsForRegionURIs(EC2Client client) {
        this.client = client.getAvailabilityZoneAndRegionServices();
    }

    @Override
    @Singleton
    @Region
    public Map<String, Supplier<URI>> get() {
        Map<String, URI> regionToUris = this.client.describeRegions(new DescribeRegionsOptions[0]);
        return Maps.transformValues(regionToUris, Suppliers2.ofInstanceFunction());
    }
}

