/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.ec2.EC2AsyncClient;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ListNodesStrategy
implements ListNodesStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected static Long maxTime;
    protected final EC2AsyncClient client;
    protected final Supplier<Set<String>> regions;
    protected final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    protected final ExecutorService executor;

    @Inject
    protected EC2ListNodesStrategy(EC2AsyncClient client, @Region Supplier<Set<String>> regions, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.regions = Preconditions.checkNotNull(regions, "regions");
        this.runningInstanceToNodeMetadata = Preconditions.checkNotNull(runningInstanceToNodeMetadata, "runningInstanceToNodeMetadata");
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    public Set<? extends ComputeMetadata> listNodes() {
        return this.listDetailsOnNodesMatching((Predicate)NodePredicates.all());
    }

    public Set<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        Iterable<? extends RunningInstance> instances = this.pollRunningInstances();
        Iterable<ComputeMetadata> nodes = Iterables.filter(Iterables.transform(Iterables.filter(instances, Predicates.notNull()), this.runningInstanceToNodeMetadata), Predicates.and(Predicates.notNull(), filter));
        return ImmutableSet.copyOf(nodes);
    }

    protected Iterable<? extends RunningInstance> pollRunningInstances() {
        Iterable<? extends Set<? extends Reservation<? extends RunningInstance>>> reservations = FutureIterables.transformParallel((Iterable)this.regions.get(), new Function<String, Future<? extends Set<? extends Reservation<? extends RunningInstance>>>>(){

            @Override
            public Future<Set<? extends Reservation<? extends RunningInstance>>> apply(String from) {
                return EC2ListNodesStrategy.castToSpecificTypedFuture(EC2ListNodesStrategy.this.client.getInstanceServices().describeInstancesInRegion(from, new String[0]));
            }
        }, this.executor, maxTime, this.logger, "reservations");
        return Iterables.concat(Iterables.concat(reservations));
    }

    private static <T> Future<T> castToSpecificTypedFuture(Future<? extends T> input) {
        return input;
    }
}

