/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class InstancePresent
implements Predicate<RegionAndName> {
    private final EC2Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public InstancePresent(EC2Client client) {
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    public boolean apply(RegionAndName instance) {
        this.logger.trace("looking for instance %s/%s", instance.getRegion(), instance.getName());
        try {
            this.refresh(instance);
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected void refresh(RegionAndName instance) {
        Iterables.getOnlyElement(Iterables.getOnlyElement(this.client.getInstanceServices().describeInstancesInRegion(instance.getRegion(), instance.getName())));
    }
}

