/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain.internal;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.jclouds.domain.Location;
import org.jclouds.domain.MutableResourceMetadata;
import org.jclouds.domain.ResourceMetadata;

public class MutableResourceMetadataImpl<T extends Enum<T>>
implements MutableResourceMetadata<T>,
Serializable {
    private static final long serialVersionUID = -280558162576368264L;
    private T type;
    private String id;
    private String name;
    private Location location;
    private URI uri;
    private Map<String, String> userMetadata;

    public MutableResourceMetadataImpl() {
        this.userMetadata = Maps.newLinkedHashMap();
    }

    public MutableResourceMetadataImpl(ResourceMetadata<T> from) {
        this.type = from.getType();
        this.id = from.getProviderId();
        this.name = from.getName();
        this.location = from.getLocation();
        this.uri = from.getUri();
        this.userMetadata = from.getUserMetadata();
    }

    @Override
    public int compareTo(ResourceMetadata<T> o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProviderId() {
        return this.id;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(T type) {
        this.type = type;
    }

    @Override
    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "[type=" + this.type + ", id=" + this.id + ", name=" + this.name + ", location=" + this.location + ", uri=" + this.uri + ", userMetadata=" + this.userMetadata + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : ((Enum)this.type).hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutableResourceMetadata)) {
            return false;
        }
        MutableResourceMetadata other = (MutableResourceMetadata)obj;
        if (this.id == null ? other.getProviderId() != null : !this.id.equals(other.getProviderId())) {
            return false;
        }
        if (this.location == null ? other.getLocation() != null : !this.location.equals(other.getLocation())) {
            return false;
        }
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.type == null ? other.getType() != null : !((Enum)this.type).equals(other.getType())) {
            return false;
        }
        return !(this.uri == null ? other.getUri() != null : !this.uri.equals(other.getUri()));
    }
}

