/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;

@Singleton
public class InstanceToNodeMetadata
implements Function<Instance, NodeMetadata> {
    public static final Map<Instance.State, NodeMetadata.Status> instanceToNodeStatus = ImmutableMap.builder().put(Instance.State.STOPPED, NodeMetadata.Status.SUSPENDED).put(Instance.State.RUNNING, NodeMetadata.Status.RUNNING).put(Instance.State.PENDING, NodeMetadata.Status.PENDING).put(Instance.State.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).put(Instance.State.SHUTTING_DOWN, NodeMetadata.Status.PENDING).put(Instance.State.START, NodeMetadata.Status.PENDING).build();
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Set<? extends Location>> locations;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;

    protected Hardware parseHardware(Instance from) {
        try {
            return Iterables.find((Iterable)this.hardwares.get(), new FindHardwareForInstance(from));
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching hardware for instance %s", from);
            return null;
        }
    }

    protected OperatingSystem parseOperatingSystem(Instance from) {
        try {
            return Iterables.find((Iterable)this.images.get(), new FindImageForInstance(from)).getOperatingSystem();
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching image for instance %s", from);
            return null;
        }
    }

    protected Location parseLocation(Instance from) {
        try {
            return Iterables.find((Iterable)this.locations.get(), new FindLocationForInstance(from));
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching realm for instance %s", from);
            return null;
        }
    }

    @Inject
    InstanceToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.images = Preconditions.checkNotNull(images, "images");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares");
    }

    @Override
    public NodeMetadata apply(Instance from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.name(from.getName());
        builder.location(this.parseLocation(from));
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        builder.imageId(from.getImage().toASCIIString());
        builder.operatingSystem(this.parseOperatingSystem(from));
        builder.hardware(this.parseHardware(from));
        builder.status(instanceToNodeStatus.get((Object)from.getState()));
        builder.publicAddresses(from.getPublicAddresses());
        builder.privateAddresses(from.getPrivateAddresses());
        return builder.build();
    }

    private static class FindLocationForInstance
    implements Predicate<Location> {
        private final Instance instance;

        private FindLocationForInstance(Instance instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Location input) {
            return input.getId().equals(this.instance.getRealm().toASCIIString());
        }
    }

    private static class FindHardwareForInstance
    implements Predicate<Hardware> {
        private final Instance instance;

        private FindHardwareForInstance(Instance instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Hardware input) {
            return input.getUri().equals(this.instance.getHardwareProfile());
        }
    }

    private static class FindImageForInstance
    implements Predicate<Image> {
        private final Instance instance;

        private FindImageForInstance(Instance instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Image input) {
            return input.getUri().equals(this.instance.getImage());
        }
    }
}

