/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto.pem;

import java.io.IOException;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class PKCS1EncodedPublicKeySpec {
    private RSAPublicKeySpec keySpec;

    public PKCS1EncodedPublicKeySpec(byte[] keyBytes) throws IOException {
        this.decode(keyBytes);
    }

    public RSAPublicKeySpec getKeySpec() {
        return this.keySpec;
    }

    private void decode(byte[] keyBytes) throws IOException {
        RSAPublicKeyStructure pks = null;
        ASN1Sequence seq = (ASN1Sequence)ASN1Object.fromByteArray(keyBytes);
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(seq);
            pks = new RSAPublicKeyStructure((ASN1Sequence)info.getPublicKey());
        }
        catch (IllegalArgumentException ex) {
            pks = new RSAPublicKeyStructure(seq);
        }
        this.keySpec = new RSAPublicKeySpec(pks.getModulus(), pks.getPublicExponent());
    }
}

