/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jclouds.concurrent.SingleThreaded;

@Beta
public class Futures {
    public static <I, O> ListenableFuture<O> compose(Future<I> future, Function<? super I, ? extends O> function, ExecutorService executorService) {
        if (future instanceof ListenableFutureAdapter) {
            ListenableFutureAdapter lf = (ListenableFutureAdapter)future;
            if (lf.futureListener.adapterExecutor.getClass().isAnnotationPresent(SingleThreaded.class)) {
                return LazyListenableFutureFunctionAdapter.create(((ListenableFutureAdapter)future).futureListener, function);
            }
            return com.google.common.util.concurrent.Futures.transform(lf, function, (Executor)executorService);
        }
        if (executorService.getClass().isAnnotationPresent(SingleThreaded.class)) {
            return LazyListenableFutureFunctionAdapter.create(future, function, executorService);
        }
        return com.google.common.util.concurrent.Futures.transform(Futures.makeListenable(future, executorService), function, (Executor)executorService);
    }

    public static <T> ListenableFuture<T> makeListenable(Future<T> future, ExecutorService executorService) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return ListenableFutureAdapter.create(future, executorService);
    }

    public static class LazyListenableFutureFunctionAdapter<I, O>
    extends ForwardingObject
    implements ListenableFuture<O> {
        private final FutureListener<I> futureListener;
        private final Function<? super I, ? extends O> function;
        private final Object lock = new Object();
        private boolean set = false;
        private O value = null;

        static <I, O> LazyListenableFutureFunctionAdapter<I, O> create(Future<I> future, Function<? super I, ? extends O> function, ExecutorService executor) {
            return new LazyListenableFutureFunctionAdapter<I, O>(future, function, executor);
        }

        static <I, O> LazyListenableFutureFunctionAdapter<I, O> create(FutureListener<I> futureListener, Function<? super I, ? extends O> function) {
            return new LazyListenableFutureFunctionAdapter<I, O>(futureListener, function);
        }

        private LazyListenableFutureFunctionAdapter(Future<I> future, Function<? super I, ? extends O> function, ExecutorService executor) {
            this(FutureListener.create(future, executor), function);
        }

        private LazyListenableFutureFunctionAdapter(FutureListener<I> futureListener, Function<? super I, ? extends O> function) {
            this.futureListener = Preconditions.checkNotNull(futureListener, "futureListener");
            this.function = Preconditions.checkNotNull(function, "function");
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            return this.apply(this.futureListener.getFuture().get());
        }

        @Override
        public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.apply(this.futureListener.getFuture().get(timeout, unit));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private O apply(I raw) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.set) {
                    this.value = this.function.apply(raw);
                    this.set = true;
                }
                return this.value;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.futureListener.getFuture().cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.futureListener.getFuture().isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureListener.getFuture().isDone();
        }

        @Override
        public void addListener(Runnable listener, Executor exec) {
            this.futureListener.addListener(listener, exec);
        }

        @Override
        protected Object delegate() {
            return this.futureListener.getFuture();
        }
    }

    public static class ListenableFutureAdapter<T>
    extends ForwardingFuture<T>
    implements ListenableFuture<T> {
        final FutureListener<T> futureListener;

        static <T> ListenableFutureAdapter<T> create(Future<T> future, ExecutorService executor) {
            return new ListenableFutureAdapter<T>(future, executor);
        }

        private ListenableFutureAdapter(Future<T> future, ExecutorService executor) {
            this.futureListener = FutureListener.create(future, executor);
        }

        @Override
        protected Future<T> delegate() {
            return this.futureListener.getFuture();
        }

        @Override
        public void addListener(Runnable listener, Executor exec) {
            this.futureListener.addListener(listener, exec);
        }
    }

    public static class FutureListener<T> {
        final ExecutorService adapterExecutor;
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<T> delegate;

        static <T> FutureListener<T> create(Future<T> delegate, ExecutorService adapterExecutor) {
            return new FutureListener<T>(delegate, adapterExecutor);
        }

        private FutureListener(Future<T> delegate, ExecutorService adapterExecutor) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.adapterExecutor = Preconditions.checkNotNull(adapterExecutor, "adapterExecutor");
        }

        public void addListener(Runnable listener, Executor exec) {
            this.executionList.add(listener, exec);
            if (this.hasListeners.compareAndSet(false, true)) {
                if (this.delegate.isDone()) {
                    this.executionList.execute();
                    return;
                }
                this.adapterExecutor.execute(new CallGetAndRunExecutionList<T>(this.delegate, this.executionList));
            }
        }

        Future<T> getFuture() {
            return this.delegate;
        }

        ExecutorService getExecutor() {
            return this.adapterExecutor;
        }
    }

    @VisibleForTesting
    static class CallGetAndRunExecutionList<T>
    implements Runnable {
        private final Future<T> delegate;
        private final ExecutionList executionList;

        public CallGetAndRunExecutionList(Future<T> delegate, ExecutionList executionList) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.executionList = Preconditions.checkNotNull(executionList, "executionList");
        }

        @Override
        public void run() {
            try {
                this.delegate.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(String.format("interrupted calling get() on [%s], so could not run listeners", this.delegate), e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.executionList.execute();
        }

        public String toString() {
            return "[delegate=" + this.delegate + ", executionList=" + this.executionList + "]";
        }
    }
}

