/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.internal.RefreshAndDoubleCheckOnFailUnlessStatusInvalid;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;

@Singleton
public class RefreshNodeAndDoubleCheckOnFailUnlessStatusInvalid
extends RefreshAndDoubleCheckOnFailUnlessStatusInvalid<NodeMetadata.Status, NodeMetadata> {
    private final GetNodeMetadataStrategy client;

    @Inject
    public RefreshNodeAndDoubleCheckOnFailUnlessStatusInvalid(NodeMetadata.Status intended, GetNodeMetadataStrategy client) {
        this(intended, ImmutableSet.of(NodeMetadata.Status.ERROR), client);
    }

    public RefreshNodeAndDoubleCheckOnFailUnlessStatusInvalid(NodeMetadata.Status intended, Set<NodeMetadata.Status> invalids, GetNodeMetadataStrategy client) {
        super(intended, invalids);
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    protected NodeMetadata refreshOrNull(NodeMetadata resource) {
        if (resource == null || resource.getId() == null) {
            return null;
        }
        return this.client.getNode(resource.getId());
    }
}

