/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.jclouds.compute.domain.OperatingSystem;

public class OperatingSystemPredicates {
    public static Predicate<OperatingSystem> isUnix() {
        return new Predicate<OperatingSystem>(){

            @Override
            public boolean apply(OperatingSystem os) {
                if (os.getFamily() != null) {
                    switch (os.getFamily()) {
                        case WINDOWS: {
                            return false;
                        }
                    }
                }
                for (String toMatch : OperatingSystemPredicates.searchStrings(os)) {
                    if (toMatch == null || toMatch.toLowerCase().indexOf("windows") == -1) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "isUnix()";
            }
        };
    }

    public static Predicate<OperatingSystem> supportsApt() {
        return new Predicate<OperatingSystem>(){

            @Override
            public boolean apply(OperatingSystem os) {
                if (os.getFamily() != null) {
                    switch (os.getFamily()) {
                        case DEBIAN: 
                        case UBUNTU: {
                            return true;
                        }
                    }
                }
                for (String toMatch : OperatingSystemPredicates.searchStrings(os)) {
                    if ((toMatch == null || toMatch.toLowerCase().indexOf("ubuntu") == -1) && toMatch.toLowerCase().indexOf("debian") == -1) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "supportsApt()";
            }
        };
    }

    public static Predicate<OperatingSystem> supportsYum() {
        return new Predicate<OperatingSystem>(){

            @Override
            public boolean apply(OperatingSystem os) {
                if (os.getFamily() != null) {
                    switch (os.getFamily()) {
                        case CENTOS: 
                        case AMZN_LINUX: 
                        case FEDORA: 
                        case RHEL: {
                            return true;
                        }
                    }
                }
                for (String toMatch : OperatingSystemPredicates.searchStrings(os)) {
                    if (toMatch.toLowerCase().indexOf("centos") == -1 && toMatch.toLowerCase().indexOf("rhel") == -1 && toMatch.toLowerCase().replace(" ", "").indexOf("redhate") == -1 && toMatch.toLowerCase().indexOf("fedora") == -1) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "supportsYum()";
            }
        };
    }

    public static Predicate<OperatingSystem> supportsZypper() {
        return new Predicate<OperatingSystem>(){

            @Override
            public boolean apply(OperatingSystem os) {
                if (os.getFamily() != null) {
                    switch (os.getFamily()) {
                        case SUSE: {
                            return true;
                        }
                    }
                }
                for (String toMatch : OperatingSystemPredicates.searchStrings(os)) {
                    if (toMatch == null || toMatch.toLowerCase().indexOf("suse") == -1) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "supportsZypper()";
            }
        };
    }

    public static Predicate<OperatingSystem> any() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<OperatingSystem> is64Bit() {
        return new Predicate<OperatingSystem>(){

            @Override
            public boolean apply(OperatingSystem os) {
                return os.is64Bit();
            }

            public String toString() {
                return "is64Bit()";
            }
        };
    }

    static Iterable<String> searchStrings(OperatingSystem os) {
        LinkedHashSet<String> search = Sets.newLinkedHashSet();
        if (os.getName() != null) {
            search.add(os.getName());
        }
        if (os.getDescription() != null) {
            search.add(os.getDescription());
        }
        return search;
    }
}

