/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum Statistics {
    AVERAGE,
    SUM,
    SAMPLE_COUNT,
    MAXIMUM,
    MINIMUM,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static Statistics fromValue(String value) {
        try {
            return Statistics.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(value, "value")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

