/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.binders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.inject.Inject;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.domain.StatisticValues;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Beta
public class MetricDataBinder
implements Binder {
    private final DateService dateService;

    @Inject
    protected MetricDataBinder(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Iterable metrics = (Iterable)Preconditions.checkNotNull(input, "metrics must be set!");
        ImmutableMultimap.Builder<String, String> formParameters = ImmutableMultimap.builder();
        int metricDatumIndex = 1;
        for (MetricDatum metricDatum : metrics) {
            int dimensionIndex = 1;
            for (Dimension dimension : metricDatum.getDimensions()) {
                formParameters.put("MetricData.member." + metricDatumIndex + ".Dimensions.member." + dimensionIndex + ".Name", dimension.getName());
                formParameters.put("MetricData.member." + metricDatumIndex + ".Dimensions.member." + dimensionIndex + ".Value", dimension.getValue());
                ++dimensionIndex;
            }
            formParameters.put("MetricData.member." + metricDatumIndex + ".MetricName", metricDatum.getMetricName());
            if (metricDatum.getStatisticValues().isPresent()) {
                StatisticValues statisticValues = metricDatum.getStatisticValues().get();
                formParameters.put("MetricData.member." + metricDatumIndex + ".StatisticValues.Maximum", String.valueOf(statisticValues.getMaximum()));
                formParameters.put("MetricData.member." + metricDatumIndex + ".StatisticValues.Minimum", String.valueOf(statisticValues.getMinimum()));
                formParameters.put("MetricData.member." + metricDatumIndex + ".StatisticValues.SampleCount", String.valueOf(statisticValues.getSampleCount()));
                formParameters.put("MetricData.member." + metricDatumIndex + ".StatisticValues.Sum", String.valueOf(statisticValues.getSum()));
            }
            if (metricDatum.getTimestamp().isPresent()) {
                formParameters.put("MetricData.member." + metricDatumIndex + ".Timestamp", this.dateService.iso8601SecondsDateFormat(metricDatum.getTimestamp().get()));
            }
            formParameters.put("MetricData.member." + metricDatumIndex + ".Unit", String.valueOf((Object)metricDatum.getUnit()));
            if (metricDatum.getValue().isPresent()) {
                formParameters.put("MetricData.member." + metricDatumIndex + ".Value", String.valueOf(metricDatum.getValue().get()));
            }
            ++metricDatumIndex;
        }
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(formParameters.build())).build();
    }
}

