/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.LoadBalancerRule;
import org.jclouds.logging.Logger;

@Singleton
public class LoadBalancerRuleActive
implements Predicate<LoadBalancerRule> {
    private final CloudStackClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public LoadBalancerRuleActive(CloudStackClient client) {
        this.client = client;
    }

    @Override
    public boolean apply(LoadBalancerRule rule) {
        this.logger.trace("looking for state on rule %s", Preconditions.checkNotNull(rule, "rule"));
        rule = this.refresh(rule);
        if (rule == null) {
            return false;
        }
        this.logger.trace("%s: looking for rule state %s: currently: %s", new Object[]{rule.getId(), LoadBalancerRule.State.ACTIVE, rule.getState()});
        return rule.getState() == LoadBalancerRule.State.ACTIVE;
    }

    private LoadBalancerRule refresh(LoadBalancerRule rule) {
        return this.client.getLoadBalancerClient().getLoadBalancerRule(rule.getId());
    }
}

