/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.domain.StorageType;
import org.jclouds.cloudstack.domain.SystemVmType;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class CreateServiceOfferingOptions
extends AccountInDomainOptions {
    public static final CreateServiceOfferingOptions NONE = new CreateServiceOfferingOptions();

    public CreateServiceOfferingOptions hostTags(Set<String> hostTags) {
        this.queryParameters.replaceValues("hosttags", ImmutableSet.copyOf(hostTags));
        return this;
    }

    public CreateServiceOfferingOptions isSystem(boolean isSystem) {
        this.queryParameters.replaceValues("issystem", ImmutableSet.of(isSystem + ""));
        return this;
    }

    public CreateServiceOfferingOptions limitCpuUse(boolean limitCpuUse) {
        this.queryParameters.replaceValues("limitcpuuse", ImmutableSet.of(limitCpuUse + ""));
        return this;
    }

    public CreateServiceOfferingOptions networkRateInMb(int networkRateInMb) {
        this.queryParameters.replaceValues("networkrate", ImmutableSet.of(networkRateInMb + ""));
        return this;
    }

    public CreateServiceOfferingOptions highlyAvailable(boolean highlyAvailable) {
        this.queryParameters.replaceValues("offerha", ImmutableSet.of(highlyAvailable + ""));
        return this;
    }

    public CreateServiceOfferingOptions storageType(StorageType storageType) {
        this.queryParameters.replaceValues("storagetype", ImmutableSet.of(storageType.toString()));
        return this;
    }

    public CreateServiceOfferingOptions systemVmType(SystemVmType systemVmType) {
        this.queryParameters.replaceValues("systemvmtype", ImmutableSet.of(systemVmType.toString()));
        return this;
    }

    public CreateServiceOfferingOptions tags(Set<String> tags) {
        this.queryParameters.replaceValues("tags", ImmutableSet.copyOf(tags));
        return this;
    }

    @Override
    public CreateServiceOfferingOptions accountInDomain(String account, String domain) {
        return (CreateServiceOfferingOptions)CreateServiceOfferingOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public CreateServiceOfferingOptions domainId(String domainId) {
        return (CreateServiceOfferingOptions)CreateServiceOfferingOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static CreateServiceOfferingOptions hostTags(Set<String> hostTags) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.hostTags(hostTags);
        }

        public static CreateServiceOfferingOptions isSystem(boolean isSystem) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.isSystem(isSystem);
        }

        public static CreateServiceOfferingOptions limitCpuUse(boolean limitCpuUse) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.limitCpuUse(limitCpuUse);
        }

        public static CreateServiceOfferingOptions networkRateInMb(int networkRate) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.networkRateInMb(networkRate);
        }

        public static CreateServiceOfferingOptions highlyAvailable(boolean highlyAvailable) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.highlyAvailable(highlyAvailable);
        }

        public static CreateServiceOfferingOptions storageType(StorageType storageType) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.storageType(storageType);
        }

        public static CreateServiceOfferingOptions systemVmType(SystemVmType systemVmType) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.systemVmType(systemVmType);
        }

        public static CreateServiceOfferingOptions tags(Set<String> tags) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.tags(tags);
        }

        public static CreateServiceOfferingOptions accountInDomain(String account, String domain) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.accountInDomain(account, domain);
        }

        public static CreateServiceOfferingOptions domainId(String domainId) {
            CreateServiceOfferingOptions options = new CreateServiceOfferingOptions();
            return options.domainId(domainId);
        }
    }
}

