/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

public class ParseLoginResponseFromHttpResponse
implements Function<HttpResponse, LoginResponse> {
    private ParseFirstJsonValueNamed<LoginResponse> parser;

    @Inject
    ParseLoginResponseFromHttpResponse(GsonWrapper gson) {
        this.parser = new ParseFirstJsonValueNamed<LoginResponse>(Preconditions.checkNotNull(gson, "gsonView"), new TypeLiteral<LoginResponse>(){}, "loginresponse");
    }

    @Override
    public LoginResponse apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        LoginResponse login = this.parser.apply(response);
        Preconditions.checkNotNull(login, "loginResponse");
        String jSessionId = Iterables.get(Splitter.on("=").split(Iterables.get(Splitter.on(";").trimResults().split(Iterables.getOnlyElement(response.getHeaders().get("Set-Cookie"))), 0)), 1);
        return ((LoginResponse.Builder)((LoginResponse.Builder)LoginResponse.builder().fromLoginResponse(login)).jSessionId(jSessionId)).build();
    }
}

