/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;

@Singleton
public class AddSessionKeyAndJSessionIdToRequest
implements AuthenticationFilter {
    private final Supplier<LoginResponse> loginResponseSupplier;

    @Inject
    public AddSessionKeyAndJSessionIdToRequest(Supplier<LoginResponse> loginResponseSupplier) {
        this.loginResponseSupplier = loginResponseSupplier;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        LoginResponse loginResponse = this.loginResponseSupplier.get();
        HttpMessage.Builder builder = request.toBuilder();
        builder.replaceHeader("Cookie", "JSESSIONID=" + loginResponse.getJSessionId());
        ((HttpRequest.Builder)builder).replaceQueryParam("sessionkey", loginResponse.getSessionKey());
        return ((HttpRequest.Builder)builder).build();
    }
}

