/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.javax.annotation.Nullable;

public class Volume {
    private final String id;
    private final String account;
    private final Date attached;
    private final Date created;
    private final boolean destroyed;
    private final String deviceId;
    private final String diskOfferingDisplayText;
    private final String diskOfferingId;
    private final String diskOfferingName;
    private final String domain;
    private final String domainId;
    private final String hypervisor;
    private final boolean isExtractable;
    private final String jobId;
    private final String jobStatus;
    private final String name;
    private final String serviceOfferingDisplayText;
    private final String serviceOfferingId;
    private final String serviceOfferingName;
    private final long size;
    private final String snapshotId;
    private final State state;
    private final String storage;
    private final String storageType;
    private final Type type;
    private final String virtualMachineId;
    private final String vmDisplayName;
    private final String vmName;
    private final VirtualMachine.State vmState;
    private final String zoneId;
    private final String zoneName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolume(this);
    }

    @ConstructorProperties(value={"id", "account", "attached", "created", "destroyed", "deviceid", "diskofferingdisplaytext", "diskofferingid", "diskofferingname", "domain", "domainid", "hypervisor", "isextractable", "jobid", "jobstatus", "name", "serviceofferingdisplaytext", "serviceofferingid", "serviceofferingname", "size", "snapshotid", "state", "storage", "storagetype", "type", "virtualmachineid", "vmdisplayname", "vmname", "vmstate", "zoneid", "zonename"})
    protected Volume(String id, @Nullable String account, @Nullable Date attached, @Nullable Date created, boolean destroyed, @Nullable String deviceId, @Nullable String diskOfferingDisplayText, @Nullable String diskOfferingId, @Nullable String diskOfferingName, @Nullable String domain, @Nullable String domainId, @Nullable String hypervisor, boolean isExtractable, @Nullable String jobId, @Nullable String jobStatus, @Nullable String name, @Nullable String serviceOfferingDisplayText, @Nullable String serviceOfferingId, @Nullable String serviceOfferingName, long size, @Nullable String snapshotId, @Nullable State state, @Nullable String storage, @Nullable String storageType, @Nullable Type type, @Nullable String virtualMachineId, @Nullable String vmDisplayName, @Nullable String vmName, @Nullable VirtualMachine.State vmState, @Nullable String zoneId, @Nullable String zoneName) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.account = account;
        this.attached = attached;
        this.created = created;
        this.destroyed = destroyed;
        this.deviceId = deviceId;
        this.diskOfferingDisplayText = diskOfferingDisplayText;
        this.diskOfferingId = diskOfferingId;
        this.diskOfferingName = diskOfferingName;
        this.domain = domain;
        this.domainId = domainId;
        this.hypervisor = hypervisor;
        this.isExtractable = isExtractable;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.name = name;
        this.serviceOfferingDisplayText = serviceOfferingDisplayText;
        this.serviceOfferingId = serviceOfferingId;
        this.serviceOfferingName = serviceOfferingName;
        this.size = size;
        this.snapshotId = snapshotId;
        this.state = state;
        this.storage = storage;
        this.storageType = storageType;
        this.type = type;
        this.virtualMachineId = virtualMachineId;
        this.vmDisplayName = vmDisplayName;
        this.vmName = vmName;
        this.vmState = vmState;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public Date getAttached() {
        return this.attached;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Nullable
    public String getDeviceId() {
        return this.deviceId;
    }

    @Nullable
    public String getDiskOfferingDisplayText() {
        return this.diskOfferingDisplayText;
    }

    @Nullable
    public String getDiskOfferingId() {
        return this.diskOfferingId;
    }

    @Nullable
    public String getDiskOfferingName() {
        return this.diskOfferingName;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getHypervisor() {
        return this.hypervisor;
    }

    public boolean isExtractable() {
        return this.isExtractable;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public String getJobStatus() {
        return this.jobStatus;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getServiceOfferingDisplayText() {
        return this.serviceOfferingDisplayText;
    }

    @Nullable
    public String getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    @Nullable
    public String getServiceOfferingName() {
        return this.serviceOfferingName;
    }

    public long getSize() {
        return this.size;
    }

    @Nullable
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getStorage() {
        return this.storage;
    }

    @Nullable
    public String getStorageType() {
        return this.storageType;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    @Nullable
    public String getVmDisplayName() {
        return this.vmDisplayName;
    }

    @Nullable
    public String getVmName() {
        return this.vmName;
    }

    @Nullable
    public VirtualMachine.State getVmState() {
        return this.vmState;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.account, this.attached, this.created, this.destroyed, this.deviceId, this.diskOfferingDisplayText, this.diskOfferingId, this.diskOfferingName, this.domain, this.domainId, this.hypervisor, this.isExtractable, this.jobId, this.jobStatus, this.name, this.serviceOfferingDisplayText, this.serviceOfferingId, this.serviceOfferingName, this.size, this.snapshotId, this.state, this.storage, this.storageType, this.type, this.virtualMachineId, this.vmDisplayName, this.vmName, this.vmState, this.zoneId, this.zoneName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Volume that = (Volume)Volume.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.account, that.account) && Objects.equal(this.attached, that.attached) && Objects.equal(this.created, that.created) && Objects.equal(this.destroyed, that.destroyed) && Objects.equal(this.deviceId, that.deviceId) && Objects.equal(this.diskOfferingDisplayText, that.diskOfferingDisplayText) && Objects.equal(this.diskOfferingId, that.diskOfferingId) && Objects.equal(this.diskOfferingName, that.diskOfferingName) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.hypervisor, that.hypervisor) && Objects.equal(this.isExtractable, that.isExtractable) && Objects.equal(this.jobId, that.jobId) && Objects.equal(this.jobStatus, that.jobStatus) && Objects.equal(this.name, that.name) && Objects.equal(this.serviceOfferingDisplayText, that.serviceOfferingDisplayText) && Objects.equal(this.serviceOfferingId, that.serviceOfferingId) && Objects.equal(this.serviceOfferingName, that.serviceOfferingName) && Objects.equal(this.size, that.size) && Objects.equal(this.snapshotId, that.snapshotId) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.storage, that.storage) && Objects.equal(this.storageType, that.storageType) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.virtualMachineId, that.virtualMachineId) && Objects.equal(this.vmDisplayName, that.vmDisplayName) && Objects.equal(this.vmName, that.vmName) && Objects.equal((Object)this.vmState, (Object)that.vmState) && Objects.equal(this.zoneId, that.zoneId) && Objects.equal(this.zoneName, that.zoneName);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("account", this.account).add("attached", this.attached).add("created", this.created).add("destroyed", this.destroyed).add("deviceId", this.deviceId).add("diskOfferingDisplayText", this.diskOfferingDisplayText).add("diskOfferingId", this.diskOfferingId).add("diskOfferingName", this.diskOfferingName).add("domain", this.domain).add("domainId", this.domainId).add("hypervisor", this.hypervisor).add("isExtractable", this.isExtractable).add("jobId", this.jobId).add("jobStatus", this.jobStatus).add("name", this.name).add("serviceOfferingDisplayText", this.serviceOfferingDisplayText).add("serviceOfferingId", this.serviceOfferingId).add("serviceOfferingName", this.serviceOfferingName).add("size", this.size).add("snapshotId", this.snapshotId).add("state", (Object)this.state).add("storage", this.storage).add("storageType", this.storageType).add("type", (Object)this.type).add("virtualMachineId", this.virtualMachineId).add("vmDisplayName", this.vmDisplayName).add("vmName", this.vmName).add("vmState", (Object)this.vmState).add("zoneId", this.zoneId).add("zoneName", this.zoneName);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected Date attached;
        protected Date created;
        protected boolean destroyed;
        protected String deviceId;
        protected String diskOfferingDisplayText;
        protected String diskOfferingId;
        protected String diskOfferingName;
        protected String domain;
        protected String domainId;
        protected String hypervisor;
        protected boolean isExtractable;
        protected String jobId;
        protected String jobStatus;
        protected String name;
        protected String serviceOfferingDisplayText;
        protected String serviceOfferingId;
        protected String serviceOfferingName;
        protected long size;
        protected String snapshotId;
        protected State state;
        protected String storage;
        protected String storageType;
        protected Type type;
        protected String virtualMachineId;
        protected String vmDisplayName;
        protected String vmName;
        protected VirtualMachine.State vmState;
        protected String zoneId;
        protected String zoneName;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T attached(Date attached) {
            this.attached = attached;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T destroyed(boolean destroyed) {
            this.destroyed = destroyed;
            return this.self();
        }

        public T deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this.self();
        }

        public T diskOfferingDisplayText(String diskOfferingDisplayText) {
            this.diskOfferingDisplayText = diskOfferingDisplayText;
            return this.self();
        }

        public T diskOfferingId(String diskOfferingId) {
            this.diskOfferingId = diskOfferingId;
            return this.self();
        }

        public T diskOfferingName(String diskOfferingName) {
            this.diskOfferingName = diskOfferingName;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this.self();
        }

        public T isExtractable(boolean isExtractable) {
            this.isExtractable = isExtractable;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T serviceOfferingDisplayText(String serviceOfferingDisplayText) {
            this.serviceOfferingDisplayText = serviceOfferingDisplayText;
            return this.self();
        }

        public T serviceOfferingId(String serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this.self();
        }

        public T serviceOfferingName(String serviceOfferingName) {
            this.serviceOfferingName = serviceOfferingName;
            return this.self();
        }

        public T size(long size) {
            this.size = size;
            return this.self();
        }

        public T snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T storage(String storage) {
            this.storage = storage;
            return this.self();
        }

        public T storageType(String storageType) {
            this.storageType = storageType;
            return this.self();
        }

        public T type(Type type) {
            this.type = type;
            return this.self();
        }

        public T virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this.self();
        }

        public T vmDisplayName(String vmDisplayName) {
            this.vmDisplayName = vmDisplayName;
            return this.self();
        }

        public T vmName(String vmName) {
            this.vmName = vmName;
            return this.self();
        }

        public T vmState(VirtualMachine.State vmState) {
            this.vmState = vmState;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public Volume build() {
            return new Volume(this.id, this.account, this.attached, this.created, this.destroyed, this.deviceId, this.diskOfferingDisplayText, this.diskOfferingId, this.diskOfferingName, this.domain, this.domainId, this.hypervisor, this.isExtractable, this.jobId, this.jobStatus, this.name, this.serviceOfferingDisplayText, this.serviceOfferingId, this.serviceOfferingName, this.size, this.snapshotId, this.state, this.storage, this.storageType, this.type, this.virtualMachineId, this.vmDisplayName, this.vmName, this.vmState, this.zoneId, this.zoneName);
        }

        public T fromVolume(Volume in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).attached(in.getAttached())).created(in.getCreated())).destroyed(in.isDestroyed())).deviceId(in.getDeviceId())).diskOfferingDisplayText(in.getDiskOfferingDisplayText())).diskOfferingId(in.getDiskOfferingId())).diskOfferingName(in.getDiskOfferingName())).domain(in.getDomain())).domainId(in.getDomainId())).hypervisor(in.getHypervisor())).isExtractable(in.isExtractable())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).name(in.getName())).serviceOfferingDisplayText(in.getServiceOfferingDisplayText())).serviceOfferingId(in.getServiceOfferingId())).serviceOfferingName(in.getServiceOfferingName())).size(in.getSize())).snapshotId(in.getSnapshotId())).state(in.getState())).storage(in.getStorage())).storageType(in.getStorageType())).type(in.getType())).virtualMachineId(in.getVirtualMachineId())).vmDisplayName(in.getVmDisplayName())).vmName(in.getVmName())).vmState(in.getVmState())).zoneId(in.getZoneId())).zoneName(in.getZoneName());
        }
    }

    public static enum Type {
        ROOT(0),
        DATADISK(1),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, Type> INDEX;

        private Type(int code) {
            this.code = code;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type fromValue(String resourceType) {
            Integer code = Integer.valueOf(Preconditions.checkNotNull(resourceType, "resourcetype"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex(ImmutableSet.copyOf(Type.values()), new Function<Type, Integer>(){

                @Override
                public Integer apply(Type input) {
                    return input.code;
                }
            });
        }
    }

    public static enum State {
        ALLOCATED,
        CREATING,
        READY,
        DESTROYED,
        FAILED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

