/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class TemplatePermission {
    private final String id;
    private final String account;
    private final String domainId;
    private final boolean isPublic;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTemplatePermission(this);
    }

    @ConstructorProperties(value={"id", "account", "domainid", "ispublic"})
    protected TemplatePermission(String id, @Nullable String account, @Nullable String domainId, boolean isPublic) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.account = account;
        this.domainId = domainId;
        this.isPublic = isPublic;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.account, this.domainId, this.isPublic);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TemplatePermission that = (TemplatePermission)TemplatePermission.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.account, that.account) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.isPublic, that.isPublic);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("account", this.account).add("domainId", this.domainId).add("isPublic", this.isPublic);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected String domainId;
        protected boolean isPublic;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this.self();
        }

        public TemplatePermission build() {
            return new TemplatePermission(this.id, this.account, this.domainId, this.isPublic);
        }

        public T fromTemplatePermission(TemplatePermission in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).domainId(in.getDomainId())).isPublic(in.isPublic());
        }
    }
}

