/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class IngressRule
implements Comparable<IngressRule> {
    private final String account;
    private final String CIDR;
    private final int endPort;
    private final int ICMPCode;
    private final int ICMPType;
    private final String protocol;
    private final String id;
    private final String securityGroupName;
    private final int startPort;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromIngressRule(this);
    }

    @ConstructorProperties(value={"account", "cidr", "endport", "icmpcode", "icmptype", "protocol", "ruleid", "securitygroupname", "startport"})
    protected IngressRule(@Nullable String account, @Nullable String CIDR, int endPort, int ICMPCode, int ICMPType, @Nullable String protocol, String id, @Nullable String securityGroupName, int startPort) {
        this.account = account;
        this.CIDR = CIDR;
        this.endPort = endPort;
        this.ICMPCode = ICMPCode;
        this.ICMPType = ICMPType;
        this.protocol = protocol;
        this.id = Preconditions.checkNotNull(id, "id");
        this.securityGroupName = securityGroupName;
        this.startPort = startPort;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getCIDR() {
        return this.CIDR;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public int getICMPCode() {
        return this.ICMPCode;
    }

    public int getICMPType() {
        return this.ICMPType;
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int hashCode() {
        return Objects.hashCode(this.account, this.CIDR, this.endPort, this.ICMPCode, this.ICMPType, this.protocol, this.id, this.securityGroupName, this.startPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IngressRule that = (IngressRule)IngressRule.class.cast(obj);
        return Objects.equal(this.account, that.account) && Objects.equal(this.CIDR, that.CIDR) && Objects.equal(this.endPort, that.endPort) && Objects.equal(this.ICMPCode, that.ICMPCode) && Objects.equal(this.ICMPType, that.ICMPType) && Objects.equal(this.protocol, that.protocol) && Objects.equal(this.id, that.id) && Objects.equal(this.securityGroupName, that.securityGroupName) && Objects.equal(this.startPort, that.startPort);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("account", this.account).add("CIDR", this.CIDR).add("endPort", this.endPort).add("ICMPCode", this.ICMPCode).add("ICMPType", this.ICMPType).add("protocol", this.protocol).add("id", this.id).add("securityGroupName", this.securityGroupName).add("startPort", this.startPort);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(IngressRule o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String account;
        protected String CIDR;
        protected int endPort;
        protected int ICMPCode;
        protected int ICMPType;
        protected String protocol;
        protected String id;
        protected String securityGroupName;
        protected int startPort;

        protected abstract T self();

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T CIDR(String CIDR) {
            this.CIDR = CIDR;
            return this.self();
        }

        public T endPort(int endPort) {
            this.endPort = endPort;
            return this.self();
        }

        public T ICMPCode(int ICMPCode) {
            this.ICMPCode = ICMPCode;
            return this.self();
        }

        public T ICMPType(int ICMPType) {
            this.ICMPType = ICMPType;
            return this.self();
        }

        public T protocol(String protocol) {
            this.protocol = protocol;
            return this.self();
        }

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T securityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
            return this.self();
        }

        public T startPort(int startPort) {
            this.startPort = startPort;
            return this.self();
        }

        public IngressRule build() {
            return new IngressRule(this.account, this.CIDR, this.endPort, this.ICMPCode, this.ICMPType, this.protocol, this.id, this.securityGroupName, this.startPort);
        }

        public T fromIngressRule(IngressRule in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.account(in.getAccount())).CIDR(in.getCIDR())).endPort(in.getEndPort())).ICMPCode(in.getICMPCode())).ICMPType(in.getICMPType())).protocol(in.getProtocol())).id(in.getId())).securityGroupName(in.getSecurityGroupName())).startPort(in.getStartPort());
        }
    }
}

