/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.OptionsConverter;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.predicates.NetworkPredicates;

public class AdvancedNetworkOptionsConverter
implements OptionsConverter {
    @Override
    public DeployVirtualMachineOptions apply(CloudStackTemplateOptions templateOptions, Map<String, Network> networks, String zoneId, DeployVirtualMachineOptions options) {
        Preconditions.checkArgument(templateOptions.getSecurityGroupIds().isEmpty(), "security groups cannot be specified for locations (zones) that use advanced networking");
        if (templateOptions.getNetworkIds().size() > 0) {
            options.networkIds(templateOptions.getNetworkIds());
        } else if (templateOptions.getIpsToNetworks().isEmpty()) {
            Preconditions.checkArgument(!networks.isEmpty(), "please setup a network for zone: " + zoneId);
            Network defaultNetworkInZone = Iterables.getFirst(Iterables.filter(networks.values(), Predicates.and(NetworkPredicates.defaultNetworkInZone(zoneId), NetworkPredicates.supportsStaticNAT())), null);
            if (defaultNetworkInZone == null) {
                defaultNetworkInZone = Iterables.getFirst(Iterables.filter(networks.values(), NetworkPredicates.isIsolatedNetwork()), null);
            }
            if (defaultNetworkInZone == null) {
                throw new IllegalArgumentException("please choose a specific network in zone " + zoneId + ": " + networks);
            }
            options.networkId(defaultNetworkInZone.getId());
        }
        return options;
    }
}

