/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.utils.Queries;
import org.jclouds.rest.Binder;

@Singleton
public class BindAccountSecurityGroupPairsToIndexedQueryParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof Multimap, "this binder is only valid for Multimaps!");
        Multimap pairs = (Multimap)Preconditions.checkNotNull(input, "account group pairs");
        Preconditions.checkArgument(pairs.size() > 0, "you must specify at least one account, group pair");
        Multimap<String, String> existingParams = Queries.queryParser().apply(request.getEndpoint().getQuery());
        ImmutableMultimap.Builder<String, String> map = ImmutableMultimap.builder().putAll(existingParams);
        int i = 0;
        for (Map.Entry entry : pairs.entries()) {
            map.put(String.format("usersecuritygrouplist[%d].account", i), (String)entry.getKey()).put(String.format("usersecuritygrouplist[%d].group", i++), (String)entry.getValue());
        }
        URI endpoint = Uris.uriBuilder(request.getEndpoint()).query(map.build()).build();
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(endpoint)).build();
    }
}

