/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.domain.Location;

@Singleton
public class PreinstalledDiskToImage
implements Function<DriveInfo, Image> {
    private final Supplier<Location> locationSupplier;
    private final Function<String, OsFamilyVersion64Bit> imageParser;

    @Inject
    public PreinstalledDiskToImage(Supplier<Location> locationSupplier, Function<String, OsFamilyVersion64Bit> imageParser) {
        this.locationSupplier = locationSupplier;
        this.imageParser = imageParser;
    }

    @Override
    public Image apply(DriveInfo drive) {
        if (drive.getName() == null) {
            return null;
        }
        String description = drive.getDescription() != null ? drive.getDescription() : drive.getName();
        OperatingSystem.Builder builder = OperatingSystem.builder();
        OsFamilyVersion64Bit parsed = this.imageParser.apply(drive.getName());
        builder.name(drive.getName()).description(description).is64Bit(drive.getBits() != null ? drive.getBits() == 64 : parsed.is64Bit).version(parsed.version).family(parsed.family);
        return ((ImageBuilder)new ImageBuilder().ids(drive.getUuid()).userMetadata(ImmutableMap.of("size", drive.getSize() / 1024L / 1024L / 1024L + ""))).location(this.locationSupplier.get()).name(drive.getName()).description(description).operatingSystem(builder.build()).status(Image.Status.AVAILABLE).version("").build();
    }
}

