/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Addresses {
    @Named(value="public")
    private final Set<String> publicAddresses;
    @Named(value="private")
    private final Set<String> privateAddresses;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAddresses(this);
    }

    @ConstructorProperties(value={"public", "private"})
    protected Addresses(@Nullable Set<String> publicAddresses, @Nullable Set<String> privateAddresses) {
        this.publicAddresses = publicAddresses == null ? null : ImmutableSet.copyOf(publicAddresses);
        this.privateAddresses = privateAddresses == null ? null : ImmutableSet.copyOf(privateAddresses);
    }

    @Nullable
    public Set<String> getPublicAddresses() {
        return this.publicAddresses;
    }

    @Nullable
    public Set<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    public int hashCode() {
        return Objects.hashCode(this.publicAddresses, this.privateAddresses);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Addresses that = (Addresses)Addresses.class.cast(obj);
        return Objects.equal(this.publicAddresses, that.publicAddresses) && Objects.equal(this.privateAddresses, that.privateAddresses);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("publicAddresses", this.publicAddresses).add("privateAddresses", this.privateAddresses);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Set<String> publicAddresses;
        protected Set<String> privateAddresses;

        protected abstract T self();

        public T publicAddresses(Collection<String> publicAddresses) {
            this.publicAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(publicAddresses, "publicAddresses"));
            return this.self();
        }

        public T publicAddresses(String ... in) {
            return this.publicAddresses(ImmutableSet.copyOf(in));
        }

        public T privateAddresses(Collection<String> privateAddresses) {
            this.privateAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(privateAddresses, "privateAddresses"));
            return this.self();
        }

        public T privateAddresses(String ... in) {
            return this.privateAddresses(ImmutableSet.copyOf(in));
        }

        public Addresses build() {
            return new Addresses(this.publicAddresses, this.privateAddresses);
        }

        public T fromAddresses(Addresses in) {
            return ((Builder)this.publicAddresses(in.getPublicAddresses())).privateAddresses(in.getPrivateAddresses());
        }
    }
}

