/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim;

import com.google.common.base.Preconditions;

public abstract class SettingData
implements Comparable<SettingData> {
    protected final String elementName;
    protected final String instanceID;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SettingData.builder().fromSettingData(this);
    }

    public SettingData(String elementName, String instanceID) {
        this.elementName = Preconditions.checkNotNull(elementName, "elementName");
        this.instanceID = Preconditions.checkNotNull(instanceID, "instanceID");
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
        result = 31 * result + (this.instanceID == null ? 0 : this.instanceID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SettingData other = (SettingData)obj;
        if (this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName)) {
            return false;
        }
        return !(this.instanceID == null ? other.instanceID != null : !this.instanceID.equals(other.instanceID));
    }

    public String toString() {
        return String.format("[elementName=%s, instanceID=%s]", this.elementName, this.instanceID);
    }

    @Override
    public int compareTo(SettingData o) {
        if (this.instanceID == null) {
            return -1;
        }
        return this == o ? 0 : this.instanceID.compareTo(o.instanceID);
    }

    public static class Builder {
        protected String elementName;
        protected String instanceID;

        public Builder elementName(String elementName) {
            this.elementName = Preconditions.checkNotNull(elementName, "elementName");
            return this;
        }

        public Builder instanceID(String instanceID) {
            this.instanceID = Preconditions.checkNotNull(instanceID, "instanceID");
            return this;
        }

        public Builder fromSettingData(SettingData in) {
            return this.elementName(in.getElementName()).instanceID(in.getInstanceID());
        }
    }
}

