/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.location.Provider;

@Singleton
public class TransientBlobRequestSigner
implements BlobRequestSigner {
    private final BasicAuthentication basicAuth;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Supplier<URI> endpoint;
    private final ContentMetadataCodec contentMetadataCodec;

    @Inject
    public TransientBlobRequestSigner(BasicAuthentication basicAuth, BlobToHttpGetOptions blob2HttpGetOptions, @Provider Supplier<URI> endpoint, ContentMetadataCodec contentMetadataCodec) {
        this.basicAuth = Preconditions.checkNotNull(basicAuth, "basicAuth");
        this.blob2HttpGetOptions = Preconditions.checkNotNull(blob2HttpGetOptions, "blob2HttpGetOptions");
        this.endpoint = endpoint;
        this.contentMetadataCodec = contentMetadataCodec;
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET")).endpoint(String.format("%s/%s/%s", this.endpoint.get(), container, name))).build();
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT")).endpoint(URI.create(String.format("%s/%s/%s", this.endpoint.get(), container, blob.getMetadata().getName())))).payload(blob.getPayload())).headers(this.contentMetadataCodec.toHeaders(blob.getMetadata().getContentMetadata()))).build();
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpRequest signRemoveBlob(String container, String name) {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE")).endpoint(String.format("%s/%s/%s", this.endpoint.get(), container, name))).build();
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, GetOptions options) {
        HttpRequest request = ((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET")).endpoint(URI.create(String.format("%s/%s/%s", this.endpoint.get(), container, name)))).headers(this.blob2HttpGetOptions.apply(options).buildRequestHeaders())).build();
        return this.basicAuth.filter(request);
    }
}

