/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.inject.Provides;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.concurrent.Timeout;
import org.jclouds.http.options.GetOptions;

@Timeout(duration=90L, timeUnit=TimeUnit.SECONDS)
public interface AzureBlobClient {
    @Provides
    public AzureBlob newBlob();

    public BoundedSet<ContainerProperties> listContainers(ListOptions ... var1);

    public boolean createContainer(String var1, CreateContainerOptions ... var2);

    public ContainerProperties getContainerProperties(String var1);

    public boolean containerExists(String var1);

    public void setResourceMetadata(String var1, Map<String, String> var2);

    public void deleteContainer(String var1);

    public boolean createRootContainer(CreateContainerOptions ... var1);

    public PublicAccess getPublicAccessForContainer(String var1);

    public void deleteRootContainer();

    @Timeout(duration=2L, timeUnit=TimeUnit.MINUTES)
    public ListBlobsResponse listBlobs(String var1, ListBlobsOptions ... var2);

    @Timeout(duration=2L, timeUnit=TimeUnit.MINUTES)
    public ListBlobsResponse listBlobs(ListBlobsOptions ... var1);

    @Timeout(duration=640L, timeUnit=TimeUnit.MINUTES)
    public String putBlob(String var1, AzureBlob var2);

    @Timeout(duration=640L, timeUnit=TimeUnit.MINUTES)
    public AzureBlob getBlob(String var1, String var2, GetOptions ... var3);

    public BlobProperties getBlobProperties(String var1, String var2);

    public void setBlobMetadata(String var1, String var2, Map<String, String> var3);

    public void deleteBlob(String var1, String var2);

    public boolean blobExists(String var1, String var2);
}

