/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.xml;

import javax.inject.Inject;
import org.jclouds.aws.domain.TemporaryCredentials;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public class TemporaryCredentialsHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<TemporaryCredentials> {
    private final DateService dateService;
    private StringBuilder currentText = new StringBuilder();
    private TemporaryCredentials.Builder builder = TemporaryCredentials.builder();

    @Inject
    protected TemporaryCredentialsHandler(DateService dateService) {
        this.dateService = dateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemporaryCredentials getResult() {
        try {
            TemporaryCredentials temporaryCredentials = this.builder.build();
            return temporaryCredentials;
        }
        finally {
            this.builder = TemporaryCredentials.builder();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("AccessKeyId")) {
            this.builder.accessKeyId(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("SecretAccessKey")) {
            this.builder.secretAccessKey(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("SessionToken")) {
            this.builder.sessionToken(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("Expiration")) {
            this.builder.expiration(this.dateService.iso8601DateParse(SaxUtils.currentOrNull(this.currentText)));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

