/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class DeleteResult
extends ForwardingSet<String> {
    private final Set<String> deleted;
    private final Map<String, Error> errors;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DeleteResult.builder().fromDeleteResult(this);
    }

    public DeleteResult(Set<String> deleted, Map<String, Error> errors) {
        this.deleted = ImmutableSet.copyOf(deleted);
        this.errors = ImmutableMap.copyOf(errors);
    }

    public Set<String> getDeleted() {
        return this.deleted;
    }

    public Map<String, Error> getErrors() {
        return this.errors;
    }

    @Override
    protected Set<String> delegate() {
        return this.deleted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteResult)) {
            return false;
        }
        DeleteResult that = (DeleteResult)o;
        return Objects.equal(this.errors, that.errors) && Objects.equal(this.deleted, that.deleted);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.deleted, this.errors);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("deleted", this.deleted).add("errors", this.errors).toString();
    }

    public static class Builder {
        private ImmutableSet.Builder<String> deleted = ImmutableSet.builder();
        private ImmutableMap.Builder<String, Error> errors = ImmutableMap.builder();

        public Builder putError(String key, Error error) {
            this.errors.put(key, error);
            return this;
        }

        public Builder errors(Map<String, Error> errors) {
            this.errors = ImmutableMap.builder().putAll(errors);
            return this;
        }

        public Builder deleted(Iterable<String> deleted) {
            this.deleted = ImmutableSet.builder().addAll(deleted);
            return this;
        }

        public Builder add(String key) {
            this.deleted.add((Object)key);
            return this;
        }

        public Builder addAll(Iterable<String> key) {
            this.deleted.addAll((Iterable)key);
            return this;
        }

        public DeleteResult build() {
            return new DeleteResult((Set<String>)((Object)this.deleted.build()), this.errors.build());
        }

        public Builder fromDeleteResult(DeleteResult result) {
            return this.addAll(result.getDeleted()).errors(result.getErrors());
        }
    }

    public static class Error {
        private final String code;
        private final String message;

        public Error(String code, String message) {
            this.code = Preconditions.checkNotNull(code, "code is null");
            this.message = Preconditions.checkNotNull(message, "message is null");
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error that = (Error)o;
            return Objects.equal(this.code, that.code) && Objects.equal(this.message, that.message);
        }

        public int hashCode() {
            return Objects.hashCode(this.code, this.message);
        }

        public String toString() {
            return Objects.toStringHelper(this).omitNullValues().add("code", this.code).add("message", this.message).toString();
        }
    }
}

