/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.binders;

import com.google.common.base.Preconditions;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;

public class BindIterableAsPayloadToDeleteRequest
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof Iterable, "this binder is only valid for an Iterable");
        Preconditions.checkNotNull(request, "request is null");
        Iterable keys = (Iterable)input;
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(String.format("<Object><Key>%s</Key></Object>", key));
        }
        String objects = builder.toString();
        Preconditions.checkArgument(!objects.isEmpty(), "The list of keys should not be empty.");
        String content = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete>%s</Delete>", objects);
        StringPayload payload = Payloads.newStringPayload(content);
        payload.getContentMetadata().setContentType("text/xml");
        payload.getContentMetadata().setContentMD5(CryptoStreams.md5(content.getBytes()));
        request.setPayload(payload);
        return request;
    }
}

