/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import org.jclouds.ec2.options.DescribeImagesOptions;

public class AWSDescribeImagesOptions
extends DescribeImagesOptions {
    public static final AWSDescribeImagesOptions NONE = new AWSDescribeImagesOptions();

    @Override
    public AWSDescribeImagesOptions executableBy(String identityId) {
        super.executableBy(identityId);
        return this;
    }

    @Override
    public AWSDescribeImagesOptions imageIds(String ... imageIds) {
        super.imageIds(imageIds);
        return this;
    }

    @Override
    public AWSDescribeImagesOptions imageIds(Iterable<String> imageIds) {
        super.imageIds(imageIds);
        return this;
    }

    @Override
    public AWSDescribeImagesOptions ownedBy(String ... owners) {
        super.ownedBy(owners);
        return this;
    }

    public AWSDescribeImagesOptions filters(Multimap<String, String> filters) {
        int i = 0;
        for (Map.Entry<String, Collection<String>> filter : Preconditions.checkNotNull(filters, "filters").asMap().entrySet()) {
            String filterPrefix = String.format("Filter.%s.", ++i);
            this.formParameters.put(filterPrefix + "Name", filter.getKey());
            this.indexFormValuesWithPrefix(filterPrefix + "Value", (Iterable<String>)filter.getValue());
        }
        return this;
    }

    public AWSDescribeImagesOptions filters(Map<String, String> filters) {
        return this.filters(Multimaps.forMap(Preconditions.checkNotNull(filters, "filters")));
    }

    public static class Builder
    extends DescribeImagesOptions.Builder {
        public static AWSDescribeImagesOptions executableBy(String identityId) {
            AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
            return options.executableBy(identityId);
        }

        public static AWSDescribeImagesOptions imageIds(String ... imageIds) {
            AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
            return options.imageIds(imageIds);
        }

        public static AWSDescribeImagesOptions filters(Multimap<String, String> filters) {
            AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
            return options.filters(filters);
        }

        public static AWSDescribeImagesOptions filters(Map<String, String> filters) {
            AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
            return options.filters(filters);
        }

        public static AWSDescribeImagesOptions ownedBy(String ... owners) {
            AWSDescribeImagesOptions options = new AWSDescribeImagesOptions();
            return options.ownedBy(owners);
        }
    }
}

