/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.strategy.EC2DestroyNodeStrategy;

@Singleton
public class AWSEC2DestroyNodeStrategy
extends EC2DestroyNodeStrategy {
    protected final AWSEC2Client client;
    protected final Map<String, Credentials> credentialStore;

    @Inject
    protected AWSEC2DestroyNodeStrategy(AWSEC2Client client, GetNodeMetadataStrategy getNode, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache, Map<String, Credentials> credentialStore) {
        super(client, getNode, elasticIpCache);
        this.client = Preconditions.checkNotNull(client, "client");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
    }

    @Override
    protected void destroyInstanceInRegion(String id, String region) {
        String spotId = id;
        if (id.indexOf("sir-") != 0) {
            try {
                spotId = ((AWSRunningInstance)Iterables.getOnlyElement(Iterables.concat(this.client.getInstanceServices().describeInstancesInRegion(region, id)))).getSpotInstanceRequestId();
                this.credentialStore.remove("node#" + region + "/" + spotId);
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            super.destroyInstanceInRegion(id, region);
        } else {
            this.client.getSpotInstanceServices().cancelSpotInstanceRequestsInRegion(region, spotId);
            this.credentialStore.remove("node#" + region + "/" + id);
        }
    }
}

