/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.blobstore.functions.BlobToContentMetadata;
import org.jclouds.atmos.blobstore.functions.BlobToSystemMetadata;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.blobstore.domain.BlobMetadata;

@Singleton
public class BlobMetadataToObject
implements Function<BlobMetadata, AtmosObject> {
    private final AtmosObject.Factory factory;
    private final BlobToContentMetadata blob2ContentMd;
    private final BlobToSystemMetadata blob2SysMd;

    @Inject
    protected BlobMetadataToObject(AtmosObject.Factory factory, BlobToContentMetadata blob2ContentMd, BlobToSystemMetadata blob2SysMd) {
        this.factory = factory;
        this.blob2ContentMd = blob2ContentMd;
        this.blob2SysMd = blob2SysMd;
    }

    @Override
    public AtmosObject apply(BlobMetadata from) {
        if (from == null) {
            return null;
        }
        UserMetadata userMd = new UserMetadata();
        if (from.getUserMetadata() != null) {
            for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
                userMd.getMetadata().put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        return this.factory.create(this.blob2ContentMd.apply(from), this.blob2SysMd.apply(from), userMd);
    }
}

