/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.firewall.internal;

import java.util.Set;
import org.fusesource.fabric.service.jclouds.firewall.ProviderFirewallSupport;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.SecurityGroup;

public class Ec2FirewallSupport
implements ProviderFirewallSupport {
    ProviderFirewallSupport delegate;

    @Override
    public void authorize(ComputeService service, NodeMetadata node, String source, int ... ports) {
        try {
            this.getDelegate().authorize(service, node, source, ports);
        }
        catch (NoClassDefFoundError ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public void revoke(ComputeService service, NodeMetadata node, String source, int ... ports) {
        try {
            this.getDelegate().revoke(service, node, source, ports);
        }
        catch (NoClassDefFoundError ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public void flush(ComputeService service, NodeMetadata node) {
        this.getDelegate().flush(service, node);
    }

    @Override
    public String[] getProviders() {
        return new String[]{"aws-ec2"};
    }

    private synchronized ProviderFirewallSupport getDelegate() {
        if (this.delegate == null) {
            this.delegate = new Ec2SupportDelegate();
        }
        return this.delegate;
    }

    private static final class Ec2SupportDelegate
    implements ProviderFirewallSupport {
        private Ec2SupportDelegate() {
        }

        @Override
        public void authorize(ComputeService service, NodeMetadata node, String source, int ... ports) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            EC2Client ec2Client = (EC2Client)EC2Client.class.cast(service.getContext().getProviderSpecificContext().getApi());
            String groupName = "jclouds#" + node.getGroup();
            for (int port : ports) {
                try {
                    ec2Client.getSecurityGroupServices().authorizeSecurityGroupIngressInRegion(region, groupName, IpProtocol.TCP, port, port, source);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
        }

        @Override
        public void revoke(ComputeService service, NodeMetadata node, String source, int ... ports) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            EC2Client ec2Client = (EC2Client)EC2Client.class.cast(service.getContext().getProviderSpecificContext().getApi());
            String groupName = "jclouds#" + node.getGroup() + "#" + region;
            for (int port : ports) {
                try {
                    ec2Client.getSecurityGroupServices().revokeSecurityGroupIngressInRegion(region, groupName, IpProtocol.TCP, port, port, source);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
        }

        @Override
        public void flush(ComputeService service, NodeMetadata node) {
            String region = AWSUtils.parseHandle(node.getId())[0];
            EC2Client ec2Client = (EC2Client)EC2Client.class.cast(service.getContext().getProviderSpecificContext().getApi());
            String groupName = "jclouds#" + node.getGroup() + "#" + region;
            Set<SecurityGroup> matchedSecurityGroups = ec2Client.getSecurityGroupServices().describeSecurityGroupsInRegion(region, groupName);
            for (SecurityGroup securityGroup : matchedSecurityGroups) {
                for (IpPermission ipPermission : securityGroup) {
                    for (String cdr : ipPermission.getIpRanges()) {
                        ec2Client.getSecurityGroupServices().revokeSecurityGroupIngressInRegion(region, groupName, IpProtocol.TCP, ipPermission.getFromPort(), ipPermission.getToPort(), cdr);
                    }
                }
            }
            this.authorize(service, node, "0.0.0.0/0", 22);
        }

        @Override
        public String[] getProviders() {
            return new String[]{"aws-ec2"};
        }
    }
}

