/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands.support;

import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.console.Completer;

public class DelimitedListCompleter
implements Completer {
    private Completer delegate;
    private String delimeter = ",";

    public DelimitedListCompleter(Completer delegate) {
        this.delegate = delegate;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        if (buffer == null || !buffer.contains(this.delimeter)) {
            return this.delegate.complete(buffer, cursor, candidates);
        }
        int pivot = buffer.lastIndexOf(",") + 1;
        int result = this.delegate.complete(buffer.substring(pivot), cursor, candidates);
        LinkedList<String> updatedCandidates = new LinkedList<String>();
        for (String candidate : candidates) {
            candidate = buffer.substring(0, pivot) + candidate;
            updatedCandidates.add(candidate);
        }
        candidates.clear();
        for (String candidate : updatedCandidates) {
            candidates.add(candidate);
        }
        return result;
    }

    public Completer getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Completer delegate) {
        this.delegate = delegate;
    }

    public String getDelimeter() {
        return this.delimeter;
    }

    public void setDelimeter(String delimeter) {
        this.delimeter = delimeter;
    }
}

