/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import net.schmizz.sshj.userauth.password.AccountResource;
import net.schmizz.sshj.userauth.password.PasswordFinder;

public class AuthPassword
extends AbstractAuthMethod {
    private final PasswordFinder pwdf;

    public AuthPassword(PasswordFinder pwdf) {
        super("password");
        this.pwdf = pwdf;
    }

    @Override
    public SSHPacket buildReq() throws UserAuthException {
        AccountResource accountResource = this.makeAccountResource();
        this.log.info("Requesting password for {}", accountResource);
        return (SSHPacket)((SSHPacket)super.buildReq().putBoolean(false)).putSensitiveString(this.pwdf.reqPassword(accountResource));
    }

    @Override
    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            throw new UserAuthException("Password change request received; unsupported operation");
        }
        super.handle(cmd, buf);
    }

    @Override
    public boolean shouldRetry() {
        return this.pwdf.shouldRetry(this.makeAccountResource());
    }
}

