/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.converters;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.net.MalformedURLException;
import java.net.URL;
import org.nnsoft.guice.rocoto.converters.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLConverter
extends AbstractConverter<URL> {
    public static final String CLASSPATH_URL_PREFIX = "classpath://";

    @Override
    public Object convert(String value, TypeLiteral<?> toType) {
        if (value.startsWith(CLASSPATH_URL_PREFIX)) {
            URL url;
            String path = value.substring(CLASSPATH_URL_PREFIX.length());
            while ('/' == path.charAt(0)) {
                path = path.substring(1);
            }
            ClassLoader classLoader = null;
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (classLoader == null) {
                classLoader = URLConverter.class.getClassLoader();
            }
            if ((url = classLoader.getResource(path)) == null) {
                throw new ProvisionException("class path resource '" + path + "' cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new ProvisionException("String value '" + value + "' is not a valid URL", e);
        }
    }
}

