/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.network.DhcpService;
import org.jclouds.vcloud.domain.network.Features;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.FirewallService;
import org.jclouds.vcloud.domain.network.IpRange;
import org.jclouds.vcloud.domain.network.IpScope;
import org.jclouds.vcloud.domain.network.NatService;
import org.jclouds.vcloud.domain.network.OrgNetwork;
import org.jclouds.vcloud.domain.network.firewall.FirewallPolicy;
import org.jclouds.vcloud.domain.network.firewall.FirewallProtocols;
import org.jclouds.vcloud.domain.network.firewall.FirewallRule;
import org.jclouds.vcloud.domain.network.internal.OrgNetworkImpl;
import org.jclouds.vcloud.domain.network.nat.NatPolicy;
import org.jclouds.vcloud.domain.network.nat.NatProtocol;
import org.jclouds.vcloud.domain.network.nat.NatRule;
import org.jclouds.vcloud.domain.network.nat.NatType;
import org.jclouds.vcloud.domain.network.nat.rules.MappingMode;
import org.jclouds.vcloud.domain.network.nat.rules.OneToOneVmRule;
import org.jclouds.vcloud.domain.network.nat.rules.PortForwardingRule;
import org.jclouds.vcloud.domain.network.nat.rules.VmRule;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OrgNetworkHandler
extends ParseSax.HandlerWithResult<OrgNetwork> {
    protected final TaskHandler taskHandler;
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType network;
    protected ReferenceType org;
    protected String orgDescription;
    protected List<Task> tasks = Lists.newArrayList();
    protected String startAddress;
    protected String endAddress;
    protected boolean inherited;
    protected String gateway;
    protected String netmask;
    protected String dns1;
    protected String dns2;
    protected String dnsSuffix;
    protected Set<IpRange> ipRanges = Sets.newLinkedHashSet();
    protected Set<String> allocatedIpAddresses = Sets.newLinkedHashSet();
    protected IpScope ipScope;
    protected ReferenceType parentNetwork;
    protected FenceMode fenceMode;
    protected boolean serviceEnabled;
    protected Integer defaultLeaseTime;
    protected Integer maxLeaseTime;
    protected DhcpService dhcpService;
    protected boolean inFirewallRule;
    protected boolean firewallRuleEnabled;
    protected String firewallRuleDescription;
    protected FirewallPolicy firewallPolicy;
    protected boolean tcp;
    protected boolean udp;
    protected FirewallProtocols protocols;
    protected int port;
    protected String destinationIp;
    protected List<FirewallRule> firewallRules = Lists.newArrayList();
    protected FirewallService firewallService;
    protected NatType natType;
    protected NatPolicy natPolicy;
    protected MappingMode mappingMode;
    protected String externalIP;
    protected String vAppScopedVmId;
    protected int vmNicId;
    protected int externalPort;
    protected String internalIP;
    protected int internalPort;
    protected NatProtocol natProtocol;
    protected String vAppScopedLocalId;
    protected List<NatRule> natRules = Lists.newArrayList();
    protected NatService natService;
    protected Features features;
    protected OrgNetwork.Configuration configuration;
    protected ReferenceType networkPool;
    protected Set<String> allowedExternalIpAddresses = Sets.newLinkedHashSet();

    @Inject
    public OrgNetworkHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    @Override
    public OrgNetwork getResult() {
        return new OrgNetworkImpl(this.network.getName(), this.network.getType(), this.network.getHref(), this.org, this.orgDescription, this.tasks, this.configuration, this.networkPool, this.allowedExternalIpAddresses);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "OrgNetwork")) {
            this.network = Utils.newReferenceType(attributes);
        } else if (SaxUtils.equalsOrSuffix(qName, "FirewallRule")) {
            this.inFirewallRule = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "ParentNetwork")) {
            this.parentNetwork = Utils.newReferenceType(attributes);
        } else if (SaxUtils.equalsOrSuffix(qName, "Link") && "up".equals(attributes.get("rel"))) {
            this.org = Utils.newReferenceType(attributes);
        } else {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        }
        String type = attributes.get("type");
        if (type != null && type.indexOf("networkPool+xml") != -1) {
            this.networkPool = Utils.newReferenceType(attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.taskHandler.endElement(uri, name, qName);
        if (SaxUtils.equalsOrSuffix(qName, "Task")) {
            this.tasks.add(this.taskHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
            if (this.inFirewallRule) {
                this.firewallRuleDescription = this.currentOrNull();
            } else {
                this.orgDescription = this.currentOrNull();
            }
        } else if (SaxUtils.equalsOrSuffix(qName, "FenceMode")) {
            this.fenceMode = FenceMode.fromValue(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "StartAddress")) {
            this.startAddress = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "EndAddress")) {
            this.endAddress = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "AllocatedIpAddress")) {
            this.allocatedIpAddresses.add(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "IpRange")) {
            this.ipRanges.add(new IpRange(this.startAddress, this.endAddress));
            this.startAddress = null;
            this.endAddress = null;
        } else if (SaxUtils.equalsOrSuffix(qName, "IsInherited")) {
            this.inherited = Boolean.parseBoolean(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "Gateway")) {
            this.gateway = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "Netmask")) {
            this.netmask = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "Dns1")) {
            this.dns1 = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "Dns2")) {
            this.dns2 = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "DnsSuffix")) {
            this.dnsSuffix = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "IpScope")) {
            this.ipScope = new IpScope(this.inherited, this.gateway, this.netmask, this.dns1, this.dns2, this.dnsSuffix, this.ipRanges, this.allocatedIpAddresses);
            this.inherited = false;
            this.gateway = null;
            this.netmask = null;
            this.dns1 = null;
            this.dns2 = null;
            this.dnsSuffix = null;
            this.ipRanges = Sets.newLinkedHashSet();
            this.allocatedIpAddresses = Sets.newLinkedHashSet();
        } else if (SaxUtils.equalsOrSuffix(qName, "IsEnabled")) {
            if (this.inFirewallRule) {
                this.firewallRuleEnabled = Boolean.parseBoolean(this.currentOrNull());
            } else {
                this.serviceEnabled = Boolean.parseBoolean(this.currentOrNull());
            }
        } else if (SaxUtils.equalsOrSuffix(qName, "DefaultLeaseTime")) {
            this.defaultLeaseTime = Integer.parseInt(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "MaxLeaseTime")) {
            this.maxLeaseTime = Integer.parseInt(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "DhcpService")) {
            this.dhcpService = new DhcpService(this.serviceEnabled, this.defaultLeaseTime, this.maxLeaseTime, Iterables.getOnlyElement(this.ipRanges));
            this.serviceEnabled = false;
            this.defaultLeaseTime = null;
            this.maxLeaseTime = null;
            this.ipRanges = Sets.newLinkedHashSet();
        } else if (SaxUtils.equalsOrSuffix(qName, "Policy")) {
            if (this.inFirewallRule) {
                this.firewallPolicy = FirewallPolicy.fromValue(this.currentOrNull());
            } else {
                this.natPolicy = NatPolicy.fromValue(this.currentOrNull());
            }
        } else if (SaxUtils.equalsOrSuffix(qName, "Tcp")) {
            this.tcp = Boolean.parseBoolean(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "Udp")) {
            this.udp = Boolean.parseBoolean(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "Protocols")) {
            this.protocols = new FirewallProtocols(this.tcp, this.udp);
            this.tcp = false;
            this.udp = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "DestinationIp")) {
            this.destinationIp = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix(qName, "FirewallRule")) {
            this.inFirewallRule = false;
            this.firewallRules.add(new FirewallRule(this.firewallRuleEnabled, this.firewallRuleDescription, this.firewallPolicy, this.protocols, this.port, this.destinationIp));
            this.firewallRuleEnabled = false;
            this.firewallRuleDescription = null;
            this.firewallPolicy = null;
            this.protocols = null;
            this.port = -1;
            this.destinationIp = null;
        } else if (SaxUtils.equalsOrSuffix(qName, "FirewallService")) {
            this.firewallService = new FirewallService(this.serviceEnabled, this.firewallRules);
            this.serviceEnabled = false;
            this.firewallRules = Lists.newArrayList();
        } else if (SaxUtils.equalsOrSuffix(qName, "NatType")) {
            this.natType = NatType.fromValue(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "MappingMode")) {
            this.mappingMode = MappingMode.fromValue(this.currentOrNull());
        } else if (qName.equalsIgnoreCase("ExternalIP")) {
            this.externalIP = this.currentOrNull();
        } else if (qName.equalsIgnoreCase("VAppScopedVmId")) {
            this.vAppScopedVmId = this.currentOrNull();
        } else if (qName.equalsIgnoreCase("VAppScopedLocalId")) {
            this.vAppScopedLocalId = this.currentOrNull();
        } else if (qName.equalsIgnoreCase("vmNicId")) {
            this.vmNicId = Integer.parseInt(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "OneToOneVmRule")) {
            this.natRules.add(new OneToOneVmRule(this.mappingMode, this.externalIP, this.vAppScopedVmId, this.vmNicId));
            this.mappingMode = null;
            this.externalIP = null;
            this.vAppScopedVmId = null;
            this.vmNicId = -1;
        } else if (qName.equalsIgnoreCase("ExternalPort")) {
            this.externalPort = Integer.parseInt(this.currentOrNull());
        } else if (qName.equalsIgnoreCase("InternalIP")) {
            this.internalIP = this.currentOrNull();
        } else if (qName.equalsIgnoreCase("InternalPort")) {
            this.internalPort = Integer.parseInt(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "Protocol")) {
            this.natProtocol = NatProtocol.valueOf(this.currentOrNull());
        } else if (SaxUtils.equalsOrSuffix(qName, "PortForwardingRule")) {
            this.natRules.add(new PortForwardingRule(this.externalIP, this.externalPort, this.internalIP, this.internalPort, this.natProtocol));
            this.externalIP = null;
            this.externalPort = -1;
            this.internalIP = null;
            this.internalPort = -1;
            this.natProtocol = null;
        } else if (SaxUtils.equalsOrSuffix(qName, "VmRule")) {
            this.natRules.add(new VmRule(this.externalIP, this.externalPort, this.vAppScopedLocalId, this.vmNicId, this.internalPort, this.natProtocol));
            this.externalIP = null;
            this.externalPort = -1;
            this.vAppScopedLocalId = null;
            this.vmNicId = -1;
            this.internalPort = -1;
            this.natProtocol = null;
        } else if (SaxUtils.equalsOrSuffix(qName, "NatService")) {
            this.natService = new NatService(this.serviceEnabled, this.natType, this.natPolicy, this.natRules);
            this.serviceEnabled = false;
            this.natType = null;
            this.natPolicy = null;
            this.natRules = Lists.newArrayList();
        } else if (SaxUtils.equalsOrSuffix(qName, "Features")) {
            this.features = new Features(this.dhcpService, this.firewallService, this.natService);
            this.dhcpService = null;
            this.firewallService = null;
            this.natService = null;
        } else if (SaxUtils.equalsOrSuffix(qName, "Configuration")) {
            this.configuration = new OrgNetworkImpl.ConfigurationImpl(this.ipScope, this.parentNetwork, this.fenceMode, this.features);
            this.ipScope = null;
            this.parentNetwork = null;
            this.fenceMode = null;
            this.features = null;
        } else if (SaxUtils.equalsOrSuffix(qName, "AllowedExternalIpAddress")) {
            this.allowedExternalIpAddresses.add(this.currentOrNull());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

