/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.predicates.validators.DnsNameValidator;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.vcloud.binders.BindCloneVAppParamsToXmlPayload;
import org.jclouds.vcloud.binders.BindDeployVAppParamsToXmlPayload;
import org.jclouds.vcloud.binders.BindUndeployVAppParamsToXmlPayload;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.jclouds.vcloud.functions.OrgNameVDCNameResourceEntityNameToEndpoint;
import org.jclouds.vcloud.options.CloneVAppOptions;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VAppHandler;

@RequestFilters(value={AddVCloudAuthorizationAndCookieToRequest.class})
public interface VAppAsyncClient {
    @POST
    @Path(value="/action/cloneVApp")
    @Produces(value={"application/vnd.vmware.vcloud.cloneVAppParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @XMLResponseParser(value=TaskHandler.class)
    @MapBinder(value=BindCloneVAppParamsToXmlPayload.class)
    public ListenableFuture<Task> copyVAppToVDCAndName(@PayloadParam(value="Source") URI var1, @EndpointParam URI var2, @PayloadParam(value="name") @ParamValidators(value={DnsNameValidator.class}) String var3, CloneVAppOptions ... var4);

    @POST
    @Path(value="/action/cloneVApp")
    @Produces(value={"application/vnd.vmware.vcloud.cloneVAppParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @XMLResponseParser(value=TaskHandler.class)
    @PayloadParams(keys={"IsSourceDelete"}, values={"true"})
    @MapBinder(value=BindCloneVAppParamsToXmlPayload.class)
    public ListenableFuture<Task> moveVAppToVDCAndRename(@PayloadParam(value="Source") URI var1, @EndpointParam URI var2, @PayloadParam(value="name") @ParamValidators(value={DnsNameValidator.class}) String var3, CloneVAppOptions ... var4);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @XMLResponseParser(value=VAppHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VApp> findVAppInOrgVDCNamed(@Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var1, @Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var2, @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var3);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @XMLResponseParser(value=VAppHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VApp> getVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.deployVAppParams+xml"})
    @Path(value="/action/deploy")
    @MapBinder(value=BindDeployVAppParamsToXmlPayload.class)
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> deployVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.deployVAppParams+xml"})
    @Path(value="/action/deploy")
    @MapBinder(value=BindDeployVAppParamsToXmlPayload.class)
    @PayloadParams(keys={"powerOn"}, values={"true"})
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> deployAndPowerOnVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.undeployVAppParams+xml"})
    @Path(value="/action/undeploy")
    @MapBinder(value=BindUndeployVAppParamsToXmlPayload.class)
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> undeployVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.undeployVAppParams+xml"})
    @Path(value="/action/undeploy")
    @MapBinder(value=BindUndeployVAppParamsToXmlPayload.class)
    @PayloadParams(keys={"saveState"}, values={"true"})
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> undeployAndSaveStateOfVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/powerOn")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> powerOnVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/powerOff")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> powerOffVApp(@EndpointParam URI var1);

    @POST
    @Path(value="/power/action/shutdown")
    public ListenableFuture<Void> shutdownVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/reset")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> resetVApp(@EndpointParam URI var1);

    @POST
    @Path(value="/power/action/reboot")
    public ListenableFuture<Void> rebootVApp(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/suspend")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> suspendVApp(@EndpointParam URI var1);

    @DELETE
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> deleteVApp(@EndpointParam URI var1);
}

