/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.jclouds.util.Strings2;

public class InputStreamChain
extends InputStream {
    private final LinkedList<InputStream> streams = new LinkedList();
    private InputStream current;

    public InputStreamChain(InputStream ... inputStreams) {
        for (InputStream stream : inputStreams) {
            this.addInputStream(stream);
        }
    }

    public InputStreamChain addInputStream(InputStream stream) {
        this.streams.addLast(stream);
        if (this.current == null) {
            this.current = this.streams.removeFirst();
        }
        return this;
    }

    public InputStreamChain addAsInputStream(String value) {
        return this.addInputStream(Strings2.toInputStream(value));
    }

    @Override
    public int read() throws IOException {
        int bit = this.current.read();
        if (bit == -1 && this.streams.size() > 0) {
            try {
                this.current.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.current = this.streams.removeFirst();
            bit = this.read();
        }
        return bit;
    }

    @Override
    public int available() throws IOException {
        int available = this.current.available();
        for (InputStream stream : this.streams) {
            available += stream.available();
        }
        return available;
    }

    @Override
    public void close() throws IOException {
        this.current.close();
    }

    @Override
    public boolean markSupported() {
        return this.current.markSupported();
    }

    @Override
    public synchronized void mark(int i) {
        this.current.mark(i);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.current.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.current.skip(l);
    }
}

