/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;

@Singleton
public class VDCURIToInternetServicesEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<URI, ? extends VDC>> orgVDCMap;
    private final Supplier<ReferenceType> defaultVDC;

    @Inject
    public VDCURIToInternetServicesEndpoint(Supplier<Map<URI, ? extends VDC>> orgVDCMap, @org.jclouds.trmk.vcloud_0_8.endpoints.VDC Supplier<ReferenceType> defaultVDC) {
        this.orgVDCMap = orgVDCMap;
        this.defaultVDC = defaultVDC;
    }

    @Override
    public URI apply(Object from) {
        try {
            return this.orgVDCMap.get().get(from == null ? this.defaultVDC.get().getHref() : from).getInternetServices().getHref();
        }
        catch (NullPointerException e) {
            throw new ResourceNotFoundException("vdc " + from + " not found in " + this.orgVDCMap.get());
        }
    }
}

