/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;

public class VAppImpl
implements VApp {
    private final String name;
    private final URI href;
    private final ReferenceType vDC;
    private final Set<ReferenceType> extendedInfo;
    private final Status status;
    private final Long size;
    private final ListMultimap<String, String> networkToAddresses;
    private final String operatingSystemDescription;
    private final VirtualSystemSettingData system;
    private final Set<ResourceAllocationSettingData> resourceAllocations;
    private final Integer osType;

    public VAppImpl(String name, URI href, Status status, Long size, ReferenceType vDC, ListMultimap<String, String> networkToAddresses, Integer osType, String operatingSystemDescription, VirtualSystemSettingData system, Set<ResourceAllocationSettingData> resourceAllocations) {
        this(name, href, status, size, vDC, networkToAddresses, osType, operatingSystemDescription, system, resourceAllocations, new HashSet<ReferenceType>());
    }

    public VAppImpl(String name, URI href, Status status, Long size, ReferenceType vDC, ListMultimap<String, String> networkToAddresses, Integer osType, String operatingSystemDescription, VirtualSystemSettingData system, Set<ResourceAllocationSettingData> resourceAllocations, Set<ReferenceType> extendedInfo) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.href = Preconditions.checkNotNull(href, "href");
        this.status = Preconditions.checkNotNull(status, "status");
        this.size = size;
        this.vDC = vDC;
        this.networkToAddresses = Preconditions.checkNotNull(networkToAddresses, "networkToAddresses");
        this.osType = osType;
        this.operatingSystemDescription = operatingSystemDescription;
        this.system = system;
        this.resourceAllocations = Preconditions.checkNotNull(resourceAllocations, "resourceAllocations");
        this.extendedInfo = extendedInfo;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public ListMultimap<String, String> getNetworkToAddresses() {
        return this.networkToAddresses;
    }

    @Override
    public Integer getOsType() {
        return this.osType;
    }

    @Override
    public String getOperatingSystemDescription() {
        return this.operatingSystemDescription;
    }

    @Override
    public VirtualSystemSettingData getSystem() {
        return this.system;
    }

    @Override
    public Set<ResourceAllocationSettingData> getResourceAllocations() {
        return this.resourceAllocations;
    }

    @Override
    public ReferenceType getVDC() {
        return this.vDC;
    }

    @Override
    public Set<ReferenceType> getExtendedInfo() {
        return this.extendedInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.networkToAddresses == null ? 0 : this.networkToAddresses.hashCode());
        result = 31 * result + (this.operatingSystemDescription == null ? 0 : this.operatingSystemDescription.hashCode());
        result = 31 * result + (this.resourceAllocations == null ? 0 : ((Object)this.resourceAllocations).hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.osType == null ? 0 : this.osType.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.system == null ? 0 : this.system.hashCode());
        result = 31 * result + (this.vDC == null ? 0 : this.vDC.hashCode());
        result = 31 * result + (this.extendedInfo == null ? 0 : ((Object)this.extendedInfo).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VAppImpl other = (VAppImpl)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.osType == null ? other.osType != null : !this.osType.equals(other.osType)) {
            return false;
        }
        if (this.networkToAddresses == null ? other.networkToAddresses != null : !((Object)this.networkToAddresses).equals(other.networkToAddresses)) {
            return false;
        }
        if (this.operatingSystemDescription == null ? other.operatingSystemDescription != null : !this.operatingSystemDescription.equals(other.operatingSystemDescription)) {
            return false;
        }
        if (this.resourceAllocations == null ? other.resourceAllocations != null : !((Object)this.resourceAllocations).equals(other.resourceAllocations)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.system == null ? other.system != null : !this.system.equals(other.system)) {
            return false;
        }
        if (this.vDC == null ? other.vDC != null : !this.vDC.equals(other.vDC)) {
            return false;
        }
        return !(this.extendedInfo == null ? other.extendedInfo != null : !((Object)this.extendedInfo).equals(other.extendedInfo));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getHref() {
        return this.href;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public String toString() {
        return "[href=" + this.href + ", name=" + this.name + ", networkToAddresses=" + this.networkToAddresses + ", osType=" + this.osType + ", operatingSystemDescription=" + this.operatingSystemDescription + ", resourceAllocationByType=" + this.resourceAllocations + ", size=" + this.size + ", status=" + (Object)((Object)this.status) + ", system=" + this.system + ", vDC=" + this.vDC + ", extendedInfo=" + this.extendedInfo + "]";
    }

    @Override
    public String getType() {
        return "application/vnd.vmware.vcloud.vApp+xml";
    }

    @Override
    public int compareTo(ReferenceType o) {
        return this == o ? 0 : this.getHref().compareTo(o.getHref());
    }
}

