/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeClient;

@Singleton
public class TerremarkVCloudDestroyNodeStrategy
implements DestroyNodeStrategy {
    protected final TerremarkVCloudComputeClient computeClient;
    protected final GetNodeMetadataStrategy getNode;

    @Inject
    protected TerremarkVCloudDestroyNodeStrategy(TerremarkVCloudComputeClient computeClient, GetNodeMetadataStrategy getNode) {
        this.computeClient = computeClient;
        this.getNode = getNode;
    }

    @Override
    public NodeMetadata destroyNode(String id) {
        this.computeClient.stop(URI.create(Preconditions.checkNotNull(id, "node.id")));
        return this.getNode.getNode(id);
    }
}

