/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ImageForVCloudExpressVAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.functions.VAppTemplatesForResourceEntities;

@Singleton
public class ImagesInVCloudExpressVDC
implements Function<VDC, Iterable<? extends Image>> {
    private final VAppTemplatesForResourceEntities vAppTemplatesForResourceEntities;
    private final ImageForVCloudExpressVAppTemplate imageForVAppTemplateProvider;

    @Inject
    public ImagesInVCloudExpressVDC(VAppTemplatesForResourceEntities vAppTemplatesForResourceEntities, ImageForVCloudExpressVAppTemplate imageForVAppTemplateProvider) {
        this.vAppTemplatesForResourceEntities = Preconditions.checkNotNull(vAppTemplatesForResourceEntities, "vAppTemplatesForResourceEntities");
        this.imageForVAppTemplateProvider = Preconditions.checkNotNull(imageForVAppTemplateProvider, "imageForVAppTemplateProvider");
    }

    @Override
    public Iterable<? extends Image> apply(VDC from) {
        Iterable<? extends VAppTemplate> vAppTemplates = this.vAppTemplatesForResourceEntities.apply((Iterable<? extends ReferenceType>)Preconditions.checkNotNull(from, "vdc").getResourceEntities().values());
        return Iterables.transform(vAppTemplates, this.imageForVAppTemplateProvider.withParent(from));
    }
}

